/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.mail.script;

import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.util.DefaultParameterizedType;
import org.xwiki.context.Execution;
import org.xwiki.mail.ExtendedMimeMessage;
import org.xwiki.mail.MimeBodyPartFactory;
import org.xwiki.stability.Unstable;

@Unstable
public class ScriptMimeMessage
extends ExtendedMimeMessage {
    private ComponentManager componentManager;
    private Execution execution;

    ScriptMimeMessage(MimeMessage sourceMessage, Execution execution, ComponentManager componentManager) throws MessagingException {
        super(sourceMessage);
        this.execution = execution;
        this.componentManager = componentManager;
    }

    ScriptMimeMessage(Execution execution, ComponentManager componentManager) {
        this.execution = execution;
        this.componentManager = componentManager;
    }

    public BodyPart addPart(String mimeType, Object content) {
        return this.addPart(mimeType, content, Collections.emptyMap());
    }

    public BodyPart addPart(String mimeType, Object content, Map<String, Object> parameters) {
        MimeBodyPart bodyPart;
        try {
            MimeBodyPartFactory factory = this.getBodyPartFactory(mimeType, content.getClass());
            HashMap<String, Object> enhancedParameters = new HashMap<String, Object>();
            enhancedParameters.put("mimetype", mimeType);
            enhancedParameters.putAll(parameters);
            Multipart multipart = this.getMultipart();
            bodyPart = factory.create(content, enhancedParameters);
            multipart.addBodyPart((BodyPart)bodyPart);
        }
        catch (Exception e) {
            this.setError(e);
            bodyPart = null;
        }
        return bodyPart;
    }

    public void setSubject(String subject) {
        try {
            super.setSubject(subject);
        }
        catch (Exception e) {
            this.setError(e);
        }
    }

    public void setFrom(Address address) {
        try {
            super.setFrom(address);
        }
        catch (Exception e) {
            this.setError(e);
        }
    }

    public void addRecipients(Message.RecipientType type, Address[] addresses) {
        try {
            super.addRecipients(type, addresses);
        }
        catch (Exception e) {
            this.setError(e);
        }
    }

    public void addRecipient(Message.RecipientType type, Address address) {
        try {
            super.addRecipient(type, address);
        }
        catch (Exception e) {
            this.setError(e);
        }
    }

    public void addHeader(String name, String value) {
        try {
            super.addHeader(name, value);
        }
        catch (Exception e) {
            this.setError(e);
        }
    }

    private void setError(Exception e) {
        this.execution.getContext().setProperty("scriptservice.mailsender.error", (Object)e);
    }

    private MimeBodyPartFactory getBodyPartFactory(String mimeType, Class contentClass) throws MessagingException {
        MimeBodyPartFactory factory;
        try {
            factory = this.getSpecificBodyPartFactory(mimeType, contentClass);
        }
        catch (ComponentLookupException e) {
            if (String.class.isAssignableFrom(contentClass)) {
                try {
                    factory = (MimeBodyPartFactory)this.componentManager.getInstance((Type)new DefaultParameterizedType(null, MimeBodyPartFactory.class, new Type[]{String.class}));
                }
                catch (ComponentLookupException eee) {
                    throw new MessagingException(String.format("Failed to find default Mime Body Part Factory for mime type [%s] and Content type [%s]", mimeType, contentClass.getName()), (Exception)((Object)e));
                }
            }
            throw new MessagingException(String.format("Failed to a Mime Body Part Factory matching the mime type [%s] and the Content type [%s]", mimeType, contentClass.getName()), (Exception)((Object)e));
        }
        return factory;
    }

    private MimeBodyPartFactory getSpecificBodyPartFactory(String mimeType, Class contentClass) throws ComponentLookupException {
        MimeBodyPartFactory factory;
        try {
            factory = (MimeBodyPartFactory)this.componentManager.getInstance((Type)new DefaultParameterizedType(null, MimeBodyPartFactory.class, new Type[]{contentClass}), String.format("%s/secure", mimeType));
        }
        catch (ComponentLookupException e) {
            factory = (MimeBodyPartFactory)this.componentManager.getInstance((Type)new DefaultParameterizedType(null, MimeBodyPartFactory.class, new Type[]{contentClass}), mimeType);
        }
        return factory;
    }

    private Multipart getMultipart() throws MessagingException, IOException {
        MimeMultipart multipart;
        if (this.isEmpty()) {
            multipart = new MimeMultipart("mixed");
            this.setContent((Multipart)multipart);
        } else {
            Object contentObject = this.getContent();
            if (contentObject instanceof Multipart) {
                multipart = (Multipart)contentObject;
            } else {
                throw new MessagingException(String.format("Unknown mail content type [%s]: [%s]", contentObject.getClass().getName(), contentObject));
            }
        }
        return multipart;
    }
}

