/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.mailsender;

import com.xpn.xwiki.api.XWiki;
import com.xpn.xwiki.web.Utils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.mail.MailSenderConfiguration;

public class MailConfiguration {
    private int port;
    private String host;
    private String from;
    private String smtpUsername;
    private String smtpPassword;
    private Properties extraProperties;
    private MailSenderConfiguration mailSenderConfiguration = (MailSenderConfiguration)Utils.getComponent(MailSenderConfiguration.class);

    public MailConfiguration() {
        this.setPort(25);
        this.setHost("localhost");
    }

    public MailConfiguration(XWiki xwiki) {
        this();
        Properties javaMailExtraProps;
        String smtpServer = this.mailSenderConfiguration.getHost();
        if (!StringUtils.isBlank((CharSequence)smtpServer)) {
            this.setHost(smtpServer);
        }
        int port = this.mailSenderConfiguration.getPort();
        this.setPort(port);
        String from = this.mailSenderConfiguration.getFromAddress();
        if (!StringUtils.isBlank((CharSequence)from)) {
            this.setFrom(from);
        }
        String smtpServerUsername = this.mailSenderConfiguration.getUsername();
        String smtpServerPassword = this.mailSenderConfiguration.getPassword();
        if (!StringUtils.isEmpty((CharSequence)smtpServerUsername) && !StringUtils.isEmpty((CharSequence)smtpServerPassword)) {
            this.setSmtpUsername(smtpServerUsername);
            this.setSmtpPassword(smtpServerPassword);
        }
        if (!(javaMailExtraProps = this.mailSenderConfiguration.getAdditionalProperties()).isEmpty()) {
            this.setExtraProperties(javaMailExtraProps);
        }
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getHost() {
        return this.host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getFrom() {
        return this.from;
    }

    public void setSmtpUsername(String smtpUsername) {
        this.smtpUsername = smtpUsername;
    }

    public String getSmtpUsername() {
        return this.smtpUsername;
    }

    public void setSmtpPassword(String smtpPassword) {
        this.smtpPassword = smtpPassword;
    }

    public String getSmtpPassword() {
        return this.smtpPassword;
    }

    public boolean usesAuthentication() {
        return !StringUtils.isEmpty((CharSequence)this.getSmtpUsername()) && !StringUtils.isEmpty((CharSequence)this.getSmtpPassword());
    }

    public void setExtraProperties(Properties extraProperties) {
        this.extraProperties = extraProperties;
    }

    public void setExtraProperties(String extraPropertiesString) {
        if (StringUtils.isEmpty((CharSequence)extraPropertiesString)) {
            this.extraProperties = null;
        } else {
            ByteArrayInputStream is = new ByteArrayInputStream(extraPropertiesString.getBytes());
            this.extraProperties = new Properties();
            try {
                this.extraProperties.load(is);
            }
            catch (IOException e) {
                throw new RuntimeException("Error configuring mail connection.", e);
            }
        }
    }

    public void appendExtraPropertiesTo(Properties externalProperties, boolean overwrite) {
        if (externalProperties == null) {
            throw new IllegalArgumentException("externalProperties can't be null");
        }
        if (this.extraProperties != null && this.extraProperties.size() > 0) {
            for (Map.Entry<Object, Object> e : this.extraProperties.entrySet()) {
                String propName = (String)e.getKey();
                String propValue = (String)e.getValue();
                if (!overwrite && externalProperties.getProperty(propName) != null) continue;
                externalProperties.setProperty(propName, propValue);
            }
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        if (this.getHost() != null) {
            buffer.append("Host [" + this.getHost() + "]");
        }
        if (this.getFrom() != null) {
            buffer.append(", From [" + this.getFrom() + "]");
        }
        buffer.append(", Port [" + this.getPort() + "]");
        if (this.usesAuthentication()) {
            buffer.append(", Username [" + this.getSmtpUsername() + "]");
            buffer.append(", Password [*****]");
        }
        return buffer.toString();
    }
}

