/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.model.reference;

import java.io.Serializable;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.LocaleUtils;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.EntityReference;

public abstract class AbstractLocalizedEntityReference
extends EntityReference {
    public static final String LOCALE = "locale";

    public AbstractLocalizedEntityReference(String name, EntityType type) {
        super(name, type);
    }

    public AbstractLocalizedEntityReference(String name, EntityType type, Locale locale) {
        this(name, type);
        this.setLocale(locale);
    }

    public AbstractLocalizedEntityReference(String name, EntityType type, EntityReference parent) {
        super(name, type, parent);
    }

    public AbstractLocalizedEntityReference(String name, EntityType type, EntityReference parent, Map<String, Serializable> parameters) {
        super(name, type, parent, parameters);
    }

    public AbstractLocalizedEntityReference(String name, EntityType type, EntityReference parent, Locale locale) {
        super(name, type, parent);
        this.setLocale(locale);
    }

    public AbstractLocalizedEntityReference(EntityReference reference) {
        super(reference);
    }

    public AbstractLocalizedEntityReference(EntityReference reference, Locale locale) {
        super(reference);
        this.setLocale(locale);
    }

    protected AbstractLocalizedEntityReference(EntityReference reference, EntityReference oldReference, EntityReference newReference) {
        super(reference, oldReference, newReference);
    }

    public AbstractLocalizedEntityReference(EntityReference reference, EntityReference parent) {
        super(reference, parent);
    }

    protected void setLocale(Locale locale) {
        this.setParameter(LOCALE, locale);
    }

    public Locale getLocale() {
        return (Locale)this.getParameter(LOCALE);
    }

    @Override
    protected void setParameter(String name, Serializable value) {
        if (value != null && !(value instanceof Locale) && LOCALE.equals(name)) {
            super.setParameter(name, LocaleUtils.toLocale((String)value.toString()));
        } else {
            super.setParameter(name, value);
        }
    }
}

