/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.model.validation.script;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.validation.EntityNameValidation;
import org.xwiki.model.validation.EntityNameValidationConfiguration;
import org.xwiki.model.validation.EntityNameValidationManager;
import org.xwiki.model.validation.internal.ReplaceCharacterEntityNameValidationConfiguration;
import org.xwiki.script.service.ScriptService;
import org.xwiki.security.authorization.ContextualAuthorizationManager;
import org.xwiki.security.authorization.Right;
import org.xwiki.stability.Unstable;

@Component
@Named(value="modelvalidation")
@Singleton
@Unstable
public class ModelValidationScriptService
implements ScriptService {
    @Inject
    private EntityNameValidationManager entityNameValidationManager;
    @Inject
    private EntityNameValidationConfiguration entityNameValidationConfiguration;
    @Inject
    private ReplaceCharacterEntityNameValidationConfiguration replaceCharacterEntityNameValidationConfiguration;
    @Inject
    private ContextualAuthorizationManager authorizationManager;

    public EntityNameValidationManager getManager() {
        if (this.authorizationManager.hasAccess(Right.PROGRAM)) {
            return this.entityNameValidationManager;
        }
        return null;
    }

    public EntityNameValidationConfiguration getConfiguration() {
        if (this.authorizationManager.hasAccess(Right.PROGRAM)) {
            return this.entityNameValidationConfiguration;
        }
        return null;
    }

    public ReplaceCharacterEntityNameValidationConfiguration getReplaceCharacterEntityNameValidationConfiguration() {
        if (this.authorizationManager.hasAccess(Right.PROGRAM)) {
            return this.replaceCharacterEntityNameValidationConfiguration;
        }
        return null;
    }

    public String transformName(String name) {
        if (this.entityNameValidationConfiguration.useTransformation() && this.entityNameValidationManager.getEntityReferenceNameStrategy() != null) {
            return this.entityNameValidationManager.getEntityReferenceNameStrategy().transform(name);
        }
        return name;
    }

    public EntityReference transformEntityReference(EntityReference sourceEntity) {
        if (this.entityNameValidationConfiguration.useTransformation() && this.entityNameValidationManager.getEntityReferenceNameStrategy() != null) {
            return this.entityNameValidationManager.getEntityReferenceNameStrategy().transform(sourceEntity);
        }
        return sourceEntity;
    }

    public String transformName(String name, String hint) {
        EntityNameValidation entityReferenceNameStrategy = this.entityNameValidationManager.getEntityReferenceNameStrategy(hint);
        if (entityReferenceNameStrategy != null) {
            return entityReferenceNameStrategy.transform(name);
        }
        return name;
    }

    public EntityReference transformEntityReference(EntityReference sourceEntity, String hint) {
        EntityNameValidation entityReferenceNameStrategy = this.entityNameValidationManager.getEntityReferenceNameStrategy(hint);
        if (entityReferenceNameStrategy != null) {
            return entityReferenceNameStrategy.transform(sourceEntity);
        }
        return sourceEntity;
    }

    public boolean isValid(String name) {
        if (this.entityNameValidationConfiguration.useValidation() && this.entityNameValidationManager.getEntityReferenceNameStrategy() != null) {
            return this.entityNameValidationManager.getEntityReferenceNameStrategy().isValid(name);
        }
        return true;
    }

    public boolean isValid(EntityReference sourceEntity) {
        if (this.entityNameValidationConfiguration.useValidation() && this.entityNameValidationManager.getEntityReferenceNameStrategy() != null) {
            return this.entityNameValidationManager.getEntityReferenceNameStrategy().isValid(sourceEntity);
        }
        return true;
    }

    public boolean isValid(String name, String hint) {
        EntityNameValidation entityReferenceNameStrategy = this.entityNameValidationManager.getEntityReferenceNameStrategy(hint);
        if (entityReferenceNameStrategy != null) {
            return entityReferenceNameStrategy.isValid(name);
        }
        return true;
    }

    public boolean isValid(EntityReference sourceEntity, String hint) {
        EntityNameValidation entityReferenceNameStrategy = this.entityNameValidationManager.getEntityReferenceNameStrategy(hint);
        if (entityReferenceNameStrategy != null) {
            return entityReferenceNameStrategy.isValid(sourceEntity);
        }
        return true;
    }
}

