/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.model.internal.reference;

import java.util.EnumMap;
import java.util.Map;
import javax.inject.Inject;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceProvider;
import org.xwiki.model.reference.InvalidEntityReferenceException;

public abstract class AbstractEntityReferenceResolver {
    protected static final Map<EntityType, EntityType> TYPE_CONVERT_MAPPING = new EnumMap<EntityType, EntityType>(EntityType.class);
    @Inject
    private EntityReferenceProvider defaultProvider;

    private String getDefaultDocumentName() {
        return this.defaultProvider.getDefaultReference(EntityType.DOCUMENT).getName();
    }

    protected abstract EntityReference getDefaultReference(EntityType var1, Object ... var2);

    protected EntityReference resolveDefaultReference(EntityType type, Object ... parameters) {
        EntityReference resolvedDefaultValue = null;
        if (parameters.length > 0 && parameters[0] instanceof EntityReference) {
            EntityReference referenceParameter = (EntityReference)parameters[0];
            EntityReference extractedReference = (referenceParameter = this.toCompatibleEntityReference(referenceParameter, type)).extractReference(type);
            if (extractedReference != null) {
                EntityReference parent;
                resolvedDefaultValue = extractedReference;
                for (parent = extractedReference.getParent(); parent != null && parent.getType() == type; parent = parent.getParent()) {
                }
                if (parent != null) {
                    resolvedDefaultValue = resolvedDefaultValue.removeParent(parent);
                }
            }
        }
        if (resolvedDefaultValue == null) {
            resolvedDefaultValue = this.getDefaultReference(type, parameters);
        }
        return resolvedDefaultValue;
    }

    protected EntityReference toCompatibleEntityReference(EntityReference referenceToConvert, EntityType toType) {
        return this.toCompatibleEntityReference(referenceToConvert, toType, true);
    }

    protected boolean isCompatible(EntityType type1, EntityType type2) {
        return type1 == type2 || type1.isAllowedAncestor(type2) || type2.isAllowedAncestor(type1);
    }

    private EntityReference toCompatibleEntityReference(EntityReference referenceToConvert, EntityType toType, boolean firstPage) {
        if (referenceToConvert == null || this.isCompatible(referenceToConvert.getType(), toType)) {
            return referenceToConvert;
        }
        EntityReference convertedParent = this.toCompatibleEntityReference(referenceToConvert.getParent(), toType, firstPage && referenceToConvert.getType() != EntityType.PAGE);
        EntityReference convertedReference = referenceToConvert.getType() == EntityType.DOCUMENT ? (this.getDefaultDocumentName().equals(referenceToConvert.getName()) ? new EntityReference(convertedParent, referenceToConvert.getParameters()) : new EntityReference(referenceToConvert.getName(), EntityType.PAGE, convertedParent, referenceToConvert.getParameters())) : (referenceToConvert.getType() == EntityType.PAGE && firstPage && (toType == EntityType.DOCUMENT || toType.isAllowedAncestor(EntityType.DOCUMENT)) ? this.toDOCUMENT(referenceToConvert, convertedParent) : this.convert(referenceToConvert, convertedParent));
        return convertedReference;
    }

    private EntityReference toDOCUMENT(EntityReference referenceToConvert, EntityReference convertedParent) {
        return new EntityReference(this.getDefaultDocumentName(), EntityType.DOCUMENT, new EntityReference(referenceToConvert.getName(), EntityType.SPACE, convertedParent), referenceToConvert.getParameters());
    }

    private EntityReference convert(EntityReference referenceToConvert, EntityReference convertedParent) {
        EntityReference convertedReference;
        EntityType convertedType = TYPE_CONVERT_MAPPING.get((Object)referenceToConvert.getType());
        if (convertedType == referenceToConvert.getType()) {
            convertedReference = referenceToConvert;
        } else if (convertedType != null) {
            convertedReference = new EntityReference(referenceToConvert.getName(), convertedType, convertedParent, referenceToConvert.getParameters());
        } else {
            throw new InvalidEntityReferenceException("Reference [" + referenceToConvert + "] cannot be converted");
        }
        return convertedReference;
    }

    static {
        TYPE_CONVERT_MAPPING.put(EntityType.WIKI, EntityType.WIKI);
        TYPE_CONVERT_MAPPING.put(EntityType.PAGE, EntityType.SPACE);
        TYPE_CONVERT_MAPPING.put(EntityType.PAGE_ATTACHMENT, EntityType.ATTACHMENT);
        TYPE_CONVERT_MAPPING.put(EntityType.PAGE_CLASS_PROPERTY, EntityType.CLASS_PROPERTY);
        TYPE_CONVERT_MAPPING.put(EntityType.PAGE_OBJECT, EntityType.OBJECT);
        TYPE_CONVERT_MAPPING.put(EntityType.PAGE_OBJECT_PROPERTY, EntityType.OBJECT_PROPERTY);
        TYPE_CONVERT_MAPPING.put(EntityType.SPACE, EntityType.PAGE);
        TYPE_CONVERT_MAPPING.put(EntityType.ATTACHMENT, EntityType.PAGE_ATTACHMENT);
        TYPE_CONVERT_MAPPING.put(EntityType.CLASS_PROPERTY, EntityType.PAGE_CLASS_PROPERTY);
        TYPE_CONVERT_MAPPING.put(EntityType.OBJECT, EntityType.PAGE_OBJECT);
        TYPE_CONVERT_MAPPING.put(EntityType.OBJECT_PROPERTY, EntityType.PAGE_OBJECT_PROPERTY);
    }
}

