/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.model.internal.reference;

import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.phase.Initializable;
import org.xwiki.model.EntityType;
import org.xwiki.model.internal.reference.AbstractEntityReferenceResolver;
import org.xwiki.model.internal.reference.SymbolScheme;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceResolver;

public abstract class AbstractStringEntityReferenceResolver
extends AbstractEntityReferenceResolver
implements EntityReferenceResolver<String>,
Initializable {
    private String[] escapeMatching;
    private String[] escapeMatchingReplace;
    @Inject
    private SymbolScheme symbolScheme;
    private Map<EntityType, Map<Character, EntityType>> referenceSetup;

    public AbstractStringEntityReferenceResolver() {
    }

    public AbstractStringEntityReferenceResolver(SymbolScheme symbolScheme) {
        this.symbolScheme = symbolScheme;
        this.initialize();
    }

    public void initialize() {
        this.referenceSetup = new HashMap<EntityType, Map<Character, EntityType>>();
        Map<EntityType, Map<EntityType, Character>> separators = this.getSymbolScheme().getSeparatorSymbols();
        for (Map.Entry<EntityType, Map<EntityType, Character>> separatorEntry : separators.entrySet()) {
            HashMap<Character, EntityType> characterMap = new HashMap<Character, EntityType>();
            for (Map.Entry<EntityType, Character> characterEntry : separatorEntry.getValue().entrySet()) {
                characterMap.put(characterEntry.getValue(), characterEntry.getKey());
            }
            this.referenceSetup.put(separatorEntry.getKey(), characterMap);
        }
        String escape = Character.toString(this.getSymbolScheme().getEscapeSymbol().charValue());
        this.escapeMatching = new String[]{escape + escape, escape};
        this.escapeMatchingReplace = new String[]{escape, ""};
    }

    @Override
    public EntityReference resolve(String entityReferenceRepresentation, EntityType type, Object ... parameters) {
        Map<Character, EntityType> typeSetup = this.getTypeSetup(type);
        if (typeSetup == null) {
            return this.getEscapedReference(entityReferenceRepresentation, type, parameters);
        }
        StringBuilder representation = entityReferenceRepresentation == null ? new StringBuilder() : new StringBuilder(entityReferenceRepresentation);
        EntityReference reference = null;
        EntityType currentType = type;
        while (typeSetup != null && !typeSetup.isEmpty()) {
            EntityType parentType = null;
            int i = representation.length();
            while (--i >= 0) {
                char currentChar = representation.charAt(i);
                int nextIndex = i - 1;
                char nextChar = '\u0000';
                if (nextIndex >= 0) {
                    nextChar = representation.charAt(nextIndex);
                }
                if (typeSetup.containsKey(Character.valueOf(currentChar))) {
                    int numberOfEscapeChars = this.getNumberOfCharsBefore(this.getSymbolScheme().getEscapeSymbol().charValue(), representation, nextIndex);
                    if (numberOfEscapeChars % 2 == 0) {
                        parentType = typeSetup.get(Character.valueOf(currentChar));
                        break;
                    }
                    representation.delete(nextIndex, i);
                    --i;
                    continue;
                }
                if (nextChar != this.getSymbolScheme().getEscapeSymbol().charValue()) continue;
                representation.delete(nextIndex, i);
                --i;
            }
            reference = this.appendNewReference(reference, this.getNewReference(i, representation, currentType, parameters));
            currentType = parentType != null ? parentType : typeSetup.values().iterator().next();
            typeSetup = this.getTypeSetup(currentType);
        }
        reference = this.appendNewReference(reference, this.getEscapedReference(representation, currentType, parameters));
        return reference;
    }

    protected Map<Character, EntityType> getTypeSetup(EntityType type) {
        return this.referenceSetup.get((Object)type);
    }

    private EntityReference getEscapedReference(CharSequence representation, EntityType type, Object ... parameters) {
        String name;
        EntityReference newReference = representation.length() > 0 ? ((name = StringUtils.replaceEach((String)representation.toString(), (String[])this.escapeMatching, (String[])this.escapeMatchingReplace)) != null ? new EntityReference(name, type) : null) : this.resolveDefaultReference(type, parameters);
        return newReference;
    }

    private EntityReference getNewReference(int i, StringBuilder representation, EntityType type, Object ... parameters) {
        EntityReference newReference;
        if (i == representation.length() - 1) {
            newReference = this.resolveDefaultReference(type, parameters);
        } else {
            String name = representation.substring(i + 1, representation.length());
            newReference = new EntityReference(name, type);
        }
        representation.delete(i < 0 ? 0 : i, representation.length());
        return newReference;
    }

    private EntityReference appendNewReference(EntityReference reference, EntityReference newReference) {
        if (newReference != null) {
            if (reference != null) {
                return reference.appendParent(newReference);
            }
            return newReference;
        }
        return reference;
    }

    private int getNumberOfCharsBefore(char c, StringBuilder representation, int currentPosition) {
        int position;
        for (position = currentPosition; position >= 0 && representation.charAt(position) == c; --position) {
        }
        return currentPosition - position;
    }

    protected SymbolScheme getSymbolScheme() {
        return this.symbolScheme;
    }
}

