/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.model.internal.reference;

import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.EntityType;
import org.xwiki.model.internal.reference.EntityReferenceFactory;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceProvider;
import org.xwiki.model.reference.SpaceReference;
import org.xwiki.model.reference.WikiReference;

@Component
@Singleton
public class DefaultSpaceReferenceProvider
implements Provider<SpaceReference> {
    @Inject
    private EntityReferenceProvider provider;
    @Inject
    private Provider<WikiReference> wikiReferenceProvider;
    @Inject
    private EntityReferenceFactory factory;
    private SpaceReference cachedReference;

    public SpaceReference get() {
        if (this.cachedReference == null) {
            EntityReference reference = this.provider.getDefaultReference(EntityType.SPACE);
            reference = reference.appendParent((EntityReference)this.wikiReferenceProvider.get());
            this.cachedReference = this.factory.getReference(new SpaceReference(reference));
        }
        return this.cachedReference;
    }
}

