/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.model.reference;

import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.xwiki.model.EntityType;

public class EntityReference
implements Serializable,
Cloneable,
Comparable<EntityReference> {
    private static final long serialVersionUID = 1L;
    private String name;
    private EntityReference parent;
    private EntityReference child;
    private EntityType type;

    public EntityReference(String name, EntityType type) {
        this(name, type, null);
    }

    public EntityReference(String name, EntityType type, EntityReference parent) {
        this.setName(name);
        this.setType(type);
        this.setParent(parent);
    }

    public void setName(String name) {
        if (StringUtils.isEmpty((String)name)) {
            throw new IllegalArgumentException("An Entity Reference name cannot be null or empty");
        }
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setParent(EntityReference parent) {
        this.parent = parent;
        if (parent != null) {
            parent.setChild(this);
        }
    }

    public EntityReference getParent() {
        return this.parent;
    }

    public void setChild(EntityReference child) {
        this.child = child;
    }

    public EntityReference getChild() {
        return this.child;
    }

    public void setType(EntityType type) {
        if (type == null) {
            throw new IllegalArgumentException("An Entity Reference type cannot be null");
        }
        this.type = type;
    }

    public EntityType getType() {
        return this.type;
    }

    public EntityReference getRoot() {
        EntityReference reference = this;
        while (reference.getParent() != null) {
            reference = reference.getParent();
        }
        return reference;
    }

    public EntityReference extractReference(EntityType type) {
        EntityReference reference;
        for (reference = this; reference != null && reference.getType() != type; reference = reference.getParent()) {
        }
        return reference;
    }

    public String toString() {
        return "name = [" + this.getName() + "], type = [" + (Object)((Object)this.getType()) + "], parent = [" + this.getParent() + "]";
    }

    public boolean equals(Object obj) {
        boolean equals = false;
        if (obj == this) {
            equals = true;
        } else if (obj instanceof EntityReference) {
            EntityReference entityReference = (EntityReference)obj;
            equals = (entityReference.getName() == null ? this.getName() == null : entityReference.getName().equals(this.getName())) && (entityReference.getParent() == null ? this.getParent() == null : entityReference.getParent().equals(this.getParent())) && (entityReference.getType() == null ? this.getType() == null : entityReference.getType().equals((Object)this.getType()));
        }
        return equals;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public EntityReference clone() {
        EntityReference reference;
        try {
            reference = (EntityReference)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Failed to clone object", e);
        }
        reference.setName(this.getName());
        reference.setType(this.getType());
        if (this.getParent() != null) {
            reference.setParent(this.getParent().clone());
        }
        return reference;
    }

    @Override
    public int compareTo(EntityReference reference) {
        return new CompareToBuilder().append((Object)this.toString(), (Object)reference.toString()).toComparison();
    }
}

