/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.model.reference;

import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;

public class AttachmentReference
extends EntityReference {
    public AttachmentReference(EntityReference reference) {
        super(reference.getName(), reference.getType(), reference.getParent());
    }

    public AttachmentReference(String fileName, DocumentReference parent) {
        super(fileName, EntityType.ATTACHMENT, parent);
    }

    @Override
    public void setParent(EntityReference parent) {
        if (parent == null || parent.getType() != EntityType.DOCUMENT) {
            throw new IllegalArgumentException("Invalid parent reference [" + parent + "] for an attachment reference");
        }
        super.setParent(new DocumentReference(parent));
    }

    @Override
    public void setType(EntityType type) {
        if (type != EntityType.ATTACHMENT) {
            throw new IllegalArgumentException("Invalid type [" + (Object)((Object)type) + "] for an attachment reference");
        }
        super.setType(EntityType.ATTACHMENT);
    }

    public DocumentReference getDocumentReference() {
        return (DocumentReference)this.extractReference(EntityType.DOCUMENT);
    }
}

