/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.model.reference;

import java.util.HashMap;
import java.util.Map;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.EntityReference;

public class EntityReferenceSet {
    private EntityReferenceEntry includes;
    private EntityReferenceEntry excludes;

    private void add(EntityReference reference, EntityReferenceEntry entry) {
        EntityReferenceEntry currentEntry = entry;
        for (EntityReference element : reference.getReversedReferenceChain()) {
            while (currentEntry.childrenType != null && currentEntry.childrenType.compareTo(element.getType()) < 0) {
                currentEntry = currentEntry.add();
            }
            if (currentEntry.childrenType == null || currentEntry.childrenType == element.getType()) {
                currentEntry.childrenType = element.getType();
                currentEntry = currentEntry.add(element.getName());
                continue;
            }
            EntityReferenceEntry newEntry = new EntityReferenceEntry(currentEntry);
            currentEntry.reset();
            currentEntry.add(newEntry);
        }
    }

    public EntityReferenceSet includes(EntityReference reference) {
        if (this.includes == null) {
            this.includes = new EntityReferenceEntry();
        }
        this.add(reference, this.includes);
        return this;
    }

    public EntityReferenceSet excludes(EntityReference reference) {
        if (this.excludes == null) {
            this.excludes = new EntityReferenceEntry();
        }
        this.add(reference, this.excludes);
        return this;
    }

    private boolean matches(EntityReference reference, EntityReferenceEntry entry, boolean def) {
        if (entry == null) {
            return def;
        }
        EntityReferenceEntry currentEntry = entry;
        for (EntityReference element : reference.getReversedReferenceChain()) {
            if (currentEntry.children == null) {
                return true;
            }
            if (currentEntry.childrenType != element.getType()) continue;
            EntityReferenceEntry nameEntry = currentEntry.children.get(element.getName());
            if (nameEntry == null) {
                currentEntry = currentEntry.children.get(null);
                if (currentEntry != null) continue;
                return false;
            }
            currentEntry = nameEntry;
        }
        return true;
    }

    public boolean matches(EntityReference reference) {
        return this.matches(reference, this.includes, true) && !this.matches(reference, this.excludes, false);
    }

    private static class EntityReferenceEntry {
        public String entityName;
        public EntityType childrenType;
        public Map<String, EntityReferenceEntry> children;

        public EntityReferenceEntry() {
        }

        public EntityReferenceEntry(String entityName) {
            this.entityName = entityName;
        }

        public EntityReferenceEntry(EntityReferenceEntry entry) {
            this.entityName = entry.entityName;
            this.childrenType = entry.childrenType;
            this.children = entry.children;
        }

        public EntityReferenceEntry add() {
            return this.add((String)null);
        }

        public void add(EntityReferenceEntry entry) {
            if (this.children == null) {
                this.children = new HashMap<String, EntityReferenceEntry>();
            }
            this.children.put(entry.entityName, entry);
        }

        public EntityReferenceEntry add(String name) {
            EntityReferenceEntry entry;
            if (this.children == null) {
                this.children = new HashMap<String, EntityReferenceEntry>();
            }
            if ((entry = this.children.get(name)) == null) {
                entry = new EntityReferenceEntry(name);
                this.children.put(name, entry);
            }
            return entry;
        }

        public void reset() {
            this.childrenType = null;
            this.children = null;
        }
    }
}

