/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.model.internal.reference.converter;

import java.lang.reflect.Type;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.properties.converter.AbstractConverter;

@Component
@Singleton
public class DocumentReferenceConverter
extends AbstractConverter<DocumentReference> {
    @Inject
    @Named(value="current")
    private DocumentReferenceResolver<String> stringResolver;
    @Inject
    @Named(value="current")
    private DocumentReferenceResolver<EntityReference> referenceResolver;
    @Inject
    @Named(value="compact")
    private EntityReferenceSerializer<String> serialier;

    protected DocumentReference convertToType(Type type, Object value) {
        if (value == null) {
            return null;
        }
        DocumentReference reference = value instanceof EntityReference ? this.referenceResolver.resolve((EntityReference)value, new Object[0]) : this.stringResolver.resolve(value.toString(), new Object[0]);
        return reference;
    }

    protected String convertToString(DocumentReference value) {
        if (value == null) {
            return null;
        }
        return this.serialier.serialize(value, new Object[0]);
    }
}

