/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.model.internal.reference.converter;

import java.lang.reflect.Type;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.EnumUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceResolver;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.properties.converter.AbstractConverter;

@Component
@Singleton
public class EntityReferenceConverter
extends AbstractConverter<EntityReference> {
    @Inject
    @Named(value="relative")
    private EntityReferenceResolver<String> stringResolver;
    @Inject
    private EntityReferenceSerializer<String> serialier;

    protected EntityReference convertToType(Type type, Object value) {
        if (value == null) {
            return null;
        }
        return this.convertToType(type, value.toString());
    }

    private EntityReference convertToType(Type type, String value) {
        String entityTypeString;
        EntityType foundEntityType;
        EntityType entityType = EntityType.DOCUMENT;
        String entityReference = value;
        int index = value.indexOf(58);
        if (index > 0 && (foundEntityType = (EntityType)EnumUtils.getEnum(EntityType.class, (String)(entityTypeString = value.substring(0, index)).toUpperCase())) != null) {
            entityType = foundEntityType;
            entityReference = ++index < value.length() ? value.substring(index) : "";
        }
        return this.stringResolver.resolve(entityReference, entityType, new Object[0]);
    }

    protected String convertToString(EntityReference value) {
        if (value == null) {
            return null;
        }
        return value.getType().toString().toLowerCase() + ':' + this.serialier.serialize(value, new Object[0]);
    }
}

