/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.model.internal.reference;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.xwiki.model.EntityType;

interface StringReferenceSeparators {
    public static final char CESCAPE = '\\';
    public static final char CWIKISEP = ':';
    public static final char CSPACESEP = '.';
    public static final char CATTACHMENTSEP = '@';
    public static final char COBJECTSEP = '^';
    public static final char CPROPERTYSEP = '.';
    public static final char CCLASSPROPSEP = '^';
    public static final String ESCAPE = Character.toString('\\');
    public static final String DBLESCAPE = ESCAPE + ESCAPE;
    public static final String WIKISEP = Character.toString(':');
    public static final String SPACESEP = Character.toString('.');
    public static final String ATTACHMENTSEP = Character.toString('@');
    public static final String OBJECTSEP = Character.toString('^');
    public static final String PROPERTYSEP = Character.toString('.');
    public static final String CLASSPROPSEP = Character.toString('^');
    public static final Map<EntityType, String[]> ESCAPES = new HashMap<EntityType, String[]>(){
        {
            this.put(EntityType.ATTACHMENT, new String[]{ATTACHMENTSEP, ESCAPE});
            this.put(EntityType.DOCUMENT, new String[]{SPACESEP, ESCAPE});
            this.put(EntityType.SPACE, new String[]{SPACESEP, WIKISEP, ESCAPE});
            this.put(EntityType.OBJECT, new String[]{OBJECTSEP, ESCAPE});
            this.put(EntityType.OBJECT_PROPERTY, new String[]{PROPERTYSEP, ESCAPE});
            this.put(EntityType.CLASS_PROPERTY, new String[]{CLASSPROPSEP, SPACESEP, ESCAPE});
        }
    };
    public static final Map<EntityType, String[]> REPLACEMENTS = new HashMap<EntityType, String[]>(){
        {
            this.put(EntityType.ATTACHMENT, new String[]{ESCAPE + ATTACHMENTSEP, DBLESCAPE});
            this.put(EntityType.DOCUMENT, new String[]{ESCAPE + SPACESEP, DBLESCAPE});
            this.put(EntityType.SPACE, new String[]{ESCAPE + SPACESEP, ESCAPE + WIKISEP, DBLESCAPE});
            this.put(EntityType.OBJECT, new String[]{ESCAPE + OBJECTSEP, DBLESCAPE});
            this.put(EntityType.OBJECT_PROPERTY, new String[]{ESCAPE + PROPERTYSEP, DBLESCAPE});
            this.put(EntityType.CLASS_PROPERTY, new String[]{ESCAPE + CLASSPROPSEP, ESCAPE + SPACESEP, DBLESCAPE});
        }
    };
    public static final Map<EntityType, Map<Character, EntityType>> REFERENCE_SETUP = new HashMap<EntityType, Map<Character, EntityType>>(){
        {
            this.put(EntityType.DOCUMENT, Collections.singletonMap(Character.valueOf('.'), EntityType.SPACE));
            this.put(EntityType.ATTACHMENT, Collections.singletonMap(Character.valueOf('@'), EntityType.DOCUMENT));
            LinkedHashMap<Character, EntityType> spaceSetup = new LinkedHashMap<Character, EntityType>();
            spaceSetup.put(Character.valueOf(':'), EntityType.WIKI);
            spaceSetup.put(Character.valueOf('.'), EntityType.SPACE);
            this.put(EntityType.SPACE, spaceSetup);
            this.put(EntityType.OBJECT, Collections.singletonMap(Character.valueOf('^'), EntityType.DOCUMENT));
            this.put(EntityType.OBJECT_PROPERTY, Collections.singletonMap(Character.valueOf('.'), EntityType.OBJECT));
            this.put(EntityType.CLASS_PROPERTY, Collections.singletonMap(Character.valueOf('^'), EntityType.DOCUMENT));
        }
    };
    public static final Map<EntityType, EntityType[]> TYPE_PARENTS = new HashMap<EntityType, EntityType[]>(){
        {
            this.put(EntityType.DOCUMENT, new EntityType[0]);
            this.put(EntityType.ATTACHMENT, new EntityType[0]);
            this.put(EntityType.SPACE, new EntityType[0]);
            this.put(EntityType.OBJECT, new EntityType[0]);
            this.put(EntityType.OBJECT_PROPERTY, new EntityType[0]);
            this.put(EntityType.CLASS_PROPERTY, new EntityType[0]);
            this.put(EntityType.WIKI, new EntityType[0]);
        }
    };
}

