/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.model.reference;

import java.util.Locale;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;

public class LocalDocumentReference
extends EntityReference {
    public LocalDocumentReference(String spaceName, String pageName) {
        super(pageName, EntityType.DOCUMENT, new EntityReference(spaceName, EntityType.SPACE));
    }

    public LocalDocumentReference(Iterable<String> spaceNames, String pageName) {
        super(pageName, EntityType.DOCUMENT, LocalDocumentReference.constructSpaceReference(spaceNames));
    }

    public LocalDocumentReference(String spaceName, String pageName, Locale locale) {
        super(pageName, EntityType.DOCUMENT, new EntityReference(spaceName, EntityType.SPACE));
        this.setLocale(locale);
    }

    public LocalDocumentReference(DocumentReference documentReference) {
        super(documentReference, documentReference.getWikiReference(), null);
    }

    public LocalDocumentReference(EntityReference reference) {
        super(reference);
    }

    public LocalDocumentReference(EntityReference entityReference, Locale locale) {
        super(entityReference);
        this.setLocale(locale);
    }

    public LocalDocumentReference(String pageName, EntityReference spaceReference) {
        super(pageName, EntityType.DOCUMENT, spaceReference);
    }

    private static EntityReference constructSpaceReference(Iterable<String> spaceNames) {
        EntityReference spaceReference = null;
        for (String spaceName : spaceNames) {
            spaceReference = new EntityReference(spaceName, EntityType.SPACE, spaceReference);
        }
        return spaceReference;
    }

    public Locale getLocale() {
        return (Locale)this.getParameter("LOCALE");
    }

    protected void setLocale(Locale locale) {
        this.setParameter("LOCALE", locale);
    }
}

