/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.model.reference;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.EntityReference;

public class EntityReferenceTreeNode {
    private final EntityReference reference;
    private final int referenceSize;
    private final Comparator<String> comparator;
    private Map<String, Map<EntityType, EntityReferenceTreeNode>> children;
    private Map<Locale, EntityReference> locales;

    protected EntityReferenceTreeNode(Comparator<String> comparator) {
        this.reference = null;
        this.referenceSize = 0;
        this.comparator = comparator;
    }

    EntityReferenceTreeNode(EntityReference reference, Comparator<String> comparator) {
        this.reference = reference;
        this.referenceSize = reference.getReversedReferenceChain().size();
        this.comparator = comparator;
    }

    void addChild(EntityReference childReference) {
        EntityReferenceTreeNode childNode;
        List<EntityReference> childReferenceList;
        EntityReference childNodeReference;
        Map<EntityType, EntityReferenceTreeNode> childrenByType;
        if (this.children == null) {
            this.children = new TreeMap<String, Map<EntityType, EntityReferenceTreeNode>>(this.comparator);
        }
        if ((childrenByType = this.children.get((childNodeReference = (childReferenceList = childReference.getReversedReferenceChain()).get(this.referenceSize)).getName())) == null) {
            childrenByType = new IdentityHashMap<EntityType, EntityReferenceTreeNode>();
            this.children.put(childNodeReference.getName(), childrenByType);
        }
        if ((childNode = childrenByType.get((Object)childNodeReference.getType())) == null) {
            childNode = new EntityReferenceTreeNode(childNodeReference, this.comparator);
        }
        if (childReferenceList.size() > this.referenceSize + 1) {
            childNode.addChild(childReference);
        }
        if (childNodeReference.getParameter("LOCALE") != null) {
            childNode.addLocale(childReference);
        }
        childrenByType.put(childNodeReference.getType(), childNode);
    }

    void addLocale(EntityReference childReference) {
        if (this.locales == null) {
            this.locales = new TreeMap<Locale, EntityReference>(LocaleComparator.INSTANCE);
        }
        this.locales.put((Locale)childReference.getParameter("LOCALE"), childReference);
    }

    public EntityReference getReference() {
        return this.reference;
    }

    public EntityReferenceTreeNode get(String name) {
        Collection<EntityReferenceTreeNode> childrenWhithName = this.getChildrenInternal(name);
        if (childrenWhithName != null && !childrenWhithName.isEmpty()) {
            return childrenWhithName.iterator().next();
        }
        return null;
    }

    public EntityReferenceTreeNode get(EntityReference path) {
        if (path == null) {
            return null;
        }
        EntityReferenceTreeNode descendant = this;
        for (EntityReference pathElement : path.getReversedReferenceChain()) {
            if (descendant.children == null) {
                return null;
            }
            Map<EntityType, EntityReferenceTreeNode> descendantByType = descendant.children.get(pathElement.getName());
            if (descendantByType == null) {
                return null;
            }
            descendant = descendantByType.get((Object)pathElement.getType());
            if (descendant != null) continue;
            return null;
        }
        return descendant;
    }

    public Collection<EntityReferenceTreeNode> getChildren() {
        if (this.children != null) {
            ArrayList<EntityReferenceTreeNode> childrenList = new ArrayList<EntityReferenceTreeNode>(this.children.size() * 2);
            for (Map<EntityType, EntityReferenceTreeNode> childrenByType : this.children.values()) {
                childrenList.addAll(childrenByType.values());
            }
            return childrenList;
        }
        return Collections.emptyList();
    }

    public Collection<EntityReferenceTreeNode> getChildren(String name) {
        Collection<EntityReferenceTreeNode> childrenWhithName = this.getChildrenInternal(name);
        return childrenWhithName != null ? Collections.unmodifiableCollection(childrenWhithName) : Collections.emptyList();
    }

    public Collection<EntityReferenceTreeNode> getChildren(EntityType type) {
        if (this.children != null) {
            ArrayList<EntityReferenceTreeNode> childrenList = new ArrayList<EntityReferenceTreeNode>(this.children.size());
            for (Map<EntityType, EntityReferenceTreeNode> childrenByType : this.children.values()) {
                EntityReferenceTreeNode child = childrenByType.get((Object)type);
                if (child == null) continue;
                childrenList.add(child);
            }
            return childrenList;
        }
        return Collections.emptyList();
    }

    public Collection<EntityReferenceTreeNode> getChildrenInternal(String name) {
        Map<EntityType, EntityReferenceTreeNode> childrenByType;
        if (this.children != null && (childrenByType = this.children.get(name)) != null) {
            return childrenByType.values();
        }
        return null;
    }

    public Collection<EntityReference> getLocales() {
        return this.locales != null ? this.locales.values() : Collections.emptyList();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.getReference() != null) {
            builder.append(this.getReference());
        }
        if (!this.getChildren().isEmpty()) {
            if (builder.length() > 0) {
                builder.append(" = ");
            }
            builder.append(this.getChildren());
        }
        return builder.toString();
    }

    static final class LocaleComparator
    implements Comparator<Locale> {
        static final LocaleComparator INSTANCE = new LocaleComparator();

        private LocaleComparator() {
        }

        @Override
        public int compare(Locale locale1, Locale locale2) {
            return locale1.toString().compareTo(locale2.toString());
        }
    }
}

