/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.model.internal;

import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.model.EntityType;
import org.xwiki.model.ModelConfiguration;

@Component
@Singleton
public class DefaultModelConfiguration
implements ModelConfiguration {
    private static final String PREFIX = "model.";
    private static final Map<EntityType, String> DEFAULT_VALUES = new HashMap<EntityType, String>(){
        {
            this.put(EntityType.WIKI, "xwiki");
            this.put(EntityType.SPACE, "Main");
            this.put(EntityType.DOCUMENT, "WebHome");
            this.put(EntityType.ATTACHMENT, "filename");
            this.put(EntityType.OBJECT, "object");
            this.put(EntityType.OBJECT_PROPERTY, "property");
            this.put(EntityType.CLASS_PROPERTY, this.get((Object)EntityType.OBJECT_PROPERTY));
        }
    };
    @Inject
    private ComponentManager componentManager;
    @Inject
    private Logger logger;

    @Override
    public String getDefaultReferenceValue(EntityType type) {
        String name;
        try {
            ConfigurationSource configuration = (ConfigurationSource)this.componentManager.getInstance(ConfigurationSource.class, "xwikiproperties");
            name = (String)configuration.getProperty("model.reference.default." + type.toString().toLowerCase(), (Object)DEFAULT_VALUES.get((Object)type));
        }
        catch (ComponentLookupException e) {
            this.logger.debug("Failed to load [" + ConfigurationSource.class.getName() + "]. Using default Model values", (Throwable)e);
            name = DEFAULT_VALUES.get((Object)type);
        }
        return name;
    }
}

