/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.notifiers.internal.email;

import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.BaseObjectReference;
import com.xpn.xwiki.plugin.scheduler.AbstractJob;
import com.xpn.xwiki.web.Utils;
import java.util.Arrays;
import java.util.Date;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.ObjectReference;
import org.xwiki.notifications.NotificationConfiguration;
import org.xwiki.notifications.notifiers.email.NotificationEmailInterval;
import org.xwiki.notifications.notifiers.internal.ModelBridge;
import org.xwiki.notifications.notifiers.internal.email.NotificationEmailSender;
import org.xwiki.notifications.notifiers.internal.email.NotificationUserIterator;

public class NotificationEmailJob
extends AbstractJob
implements Job {
    private static final String LAST_FIRE_TIME = "lastFireTime";
    private static final String XWIKI_SPACE = "XWiki";
    private static final String NOTIFICATIONS_SPACE = "Notifications";

    protected void executeJob(JobExecutionContext jobContext) throws JobExecutionException {
        NotificationConfiguration configuration = (NotificationConfiguration)Utils.getComponent(NotificationConfiguration.class);
        if (!configuration.isEnabled() || !configuration.areEmailsEnabled()) {
            return;
        }
        DocumentReference schedulerJobDocument = this.getSchedulerJobDocument(jobContext);
        BaseObjectReference emailJobObjectReference = this.getNotificationEmailJobObjectReference(schedulerJobDocument);
        NotificationUserIterator userIterator = (NotificationUserIterator)Utils.getComponent(NotificationUserIterator.class);
        userIterator.initialize(this.getJobInterval(schedulerJobDocument));
        NotificationEmailSender mailSender = (NotificationEmailSender)Utils.getComponent(NotificationEmailSender.class);
        mailSender.sendEmails(this.getPreviousFireTime(emailJobObjectReference), userIterator);
        this.setPreviousFireTime(emailJobObjectReference);
    }

    private DocumentReference getSchedulerJobDocument(JobExecutionContext jobContext) {
        JobDataMap data = jobContext.getJobDetail().getJobDataMap();
        BaseObject schedulerJobObject = (BaseObject)data.get((Object)"xjob");
        BaseObjectReference schedulerJobObjectReference = (BaseObjectReference)schedulerJobObject.getReference();
        return (DocumentReference)schedulerJobObjectReference.getParent();
    }

    private BaseObjectReference getNotificationEmailJobObjectReference(DocumentReference schedulerJobDocument) {
        DocumentReference emailJobDocument = new DocumentReference(schedulerJobDocument.getWikiReference().getName(), Arrays.asList(XWIKI_SPACE, NOTIFICATIONS_SPACE), schedulerJobDocument.getName());
        return new BaseObjectReference(new DocumentReference(schedulerJobDocument.getWikiReference().getName(), Arrays.asList(XWIKI_SPACE, NOTIFICATIONS_SPACE, "Code"), "EmailJobClass"), Integer.valueOf(0), emailJobDocument);
    }

    private NotificationEmailInterval getJobInterval(DocumentReference schedulerJobDocument) {
        if (schedulerJobDocument.getName().contains("Hourly")) {
            return NotificationEmailInterval.HOURLY;
        }
        if (schedulerJobDocument.getName().contains("Weekly")) {
            return NotificationEmailInterval.WEEKLY;
        }
        return NotificationEmailInterval.DAILY;
    }

    private Date getPreviousFireTime(BaseObjectReference emailJobObject) {
        Object previousFireTime = this.getDocumentAccessBridge().getProperty((ObjectReference)emailJobObject, LAST_FIRE_TIME);
        if (previousFireTime != null) {
            return (Date)previousFireTime;
        }
        return new Date(0L);
    }

    private void setPreviousFireTime(BaseObjectReference emailJobObject) throws JobExecutionException {
        try {
            this.getModelBridge().savePropertyInHiddenDocument(emailJobObject, LAST_FIRE_TIME, (Object)new Date());
        }
        catch (Exception e) {
            throw new JobExecutionException(String.format("Failed to update the last fire time property of [{}].", emailJobObject), (Throwable)e);
        }
    }

    private DocumentAccessBridge getDocumentAccessBridge() {
        return (DocumentAccessBridge)Utils.getComponent(DocumentAccessBridge.class);
    }

    private ModelBridge getModelBridge() {
        return (ModelBridge)Utils.getComponent(ModelBridge.class);
    }
}

