/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.xwiki.notifications.preferences.email;

import org.xwiki.stability.Unstable;

/**
 * Represent possible values for the "include diff" option of the user. We use an enum instead of Boolean so we can add
 * other values in the future (like having a simplified or a more complete diff, etc...).
 *
 * @version $Id: ded3ceeb47499d24bf55d0ff49f1a528b3aaf6db $
 * @since 9.11RC1
 */
@Unstable
public enum NotificationEmailDiffType
{
    /**
     * No diff at all.
     */
    NOTHING,

    /**
     * Include the standard diff in the emails.
     */
    STANDARD
}
