/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.preferences.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.notifications.NotificationException;
import org.xwiki.notifications.preferences.NotificationPreference;
import org.xwiki.notifications.preferences.NotificationPreferenceProvider;
import org.xwiki.notifications.preferences.TargetableNotificationPreference;
import org.xwiki.notifications.preferences.internal.ModelBridge;

public abstract class AbstractDocumentNotificationPreferenceProvider
implements NotificationPreferenceProvider {
    @Inject
    @Named(value="cached")
    protected ModelBridge cachedModelBridge;
    @Inject
    protected Logger logger;

    @Override
    public void savePreferences(List<NotificationPreference> preferences) throws NotificationException {
        HashMap<EntityReference, ArrayList<TargetableNotificationPreference>> preferencesPerTarget = new HashMap<EntityReference, ArrayList<TargetableNotificationPreference>>();
        for (NotificationPreference notificationPreference : preferences) {
            if (notificationPreference instanceof TargetableNotificationPreference) {
                TargetableNotificationPreference targetablePreference = (TargetableNotificationPreference)notificationPreference;
                ArrayList<TargetableNotificationPreference> list = (ArrayList<TargetableNotificationPreference>)preferencesPerTarget.get(targetablePreference.getTarget());
                if (list == null) {
                    list = new ArrayList<TargetableNotificationPreference>();
                    preferencesPerTarget.put(targetablePreference.getTarget(), list);
                }
                list.add(targetablePreference);
                continue;
            }
            this.logger.warn("Unsupported NotificationPreference class: [{}]. This preference will not be saved.", (Object)notificationPreference.getClass().getName());
        }
        for (Map.Entry entry : preferencesPerTarget.entrySet()) {
            this.savePreferences((List)entry.getValue(), (EntityReference)entry.getKey());
        }
    }

    protected void savePreferences(List<NotificationPreference> preferences, EntityReference target) throws NotificationException {
        if (target instanceof DocumentReference) {
            this.cachedModelBridge.saveNotificationsPreferences((DocumentReference)target, preferences);
        } else {
            this.logger.warn("Preference's target [{}] is not a document reference. The corresponding preference will not be saved.");
        }
    }
}

