/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.preferences.internal;

import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.notifications.NotificationException;
import org.xwiki.notifications.preferences.NotificationPreference;
import org.xwiki.notifications.preferences.internal.ModelBridge;

@Component
@Named(value="cached")
@Singleton
public class CachedModelBridge
implements ModelBridge {
    private static final String USER_NOTIFICATIONS_PREFERENCES = "userNotificationsPreferences";
    private static final String WIKI_NOTIFICATIONS_PREFERENCES = "wikiNotificationsPreferences";
    private static final String CACHE_KEY_PATTERN = "%s_[%s]";
    @Inject
    private ModelBridge modelBridge;
    @Inject
    private Execution execution;
    @Inject
    private EntityReferenceSerializer<String> serializer;

    @Override
    public List<NotificationPreference> getNotificationsPreferences(DocumentReference userReference) throws NotificationException {
        String specificUserNotificationsPreferences = String.format(CACHE_KEY_PATTERN, USER_NOTIFICATIONS_PREFERENCES, this.serializer.serialize((EntityReference)userReference, new Object[0]));
        ExecutionContext context = this.execution.getContext();
        if (context.hasProperty(specificUserNotificationsPreferences)) {
            return (List)context.getProperty(specificUserNotificationsPreferences);
        }
        List<NotificationPreference> preferences = this.modelBridge.getNotificationsPreferences(userReference);
        context.setProperty(specificUserNotificationsPreferences, preferences);
        return preferences;
    }

    @Override
    public List<NotificationPreference> getNotificationsPreferences(WikiReference wikiReference) throws NotificationException {
        String specificWikiNotificationsPreferences = String.format(CACHE_KEY_PATTERN, WIKI_NOTIFICATIONS_PREFERENCES, this.serializer.serialize((EntityReference)wikiReference, new Object[0]));
        ExecutionContext context = this.execution.getContext();
        if (context.hasProperty(specificWikiNotificationsPreferences)) {
            return (List)context.getProperty(specificWikiNotificationsPreferences);
        }
        List<NotificationPreference> preferences = this.modelBridge.getNotificationsPreferences(wikiReference);
        context.setProperty(specificWikiNotificationsPreferences, preferences);
        return preferences;
    }

    @Override
    public void setStartDateForUser(DocumentReference userReference, Date startDate) throws NotificationException {
        this.modelBridge.setStartDateForUser(userReference, startDate);
    }

    @Override
    public void saveNotificationsPreferences(DocumentReference userReference, List<NotificationPreference> notificationPreferences) throws NotificationException {
        this.modelBridge.saveNotificationsPreferences(userReference, notificationPreferences);
    }
}

