/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.preferences.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.notifications.NotificationException;
import org.xwiki.notifications.NotificationFormat;
import org.xwiki.notifications.preferences.NotificationPreference;
import org.xwiki.notifications.preferences.NotificationPreferenceCategory;
import org.xwiki.notifications.preferences.NotificationPreferenceManager;
import org.xwiki.notifications.preferences.NotificationPreferenceProperty;
import org.xwiki.notifications.preferences.TargetableNotificationPreference;
import org.xwiki.notifications.preferences.TargetableNotificationPreferenceBuilder;

@Component(roles={XWikiEventTypesEnabler.class})
@Singleton
public class XWikiEventTypesEnabler {
    private static final List<String> XWIKI_EVENT_TYPES = Arrays.asList("create", "update", "delete", "addComment");
    @Inject
    private NotificationPreferenceManager notificationPreferenceManager;
    @Inject
    private Provider<TargetableNotificationPreferenceBuilder> targetableNotificationPreferenceBuilderProvider;

    public void ensureXWikiNotificationsAreEnabled(DocumentReference user) throws NotificationException {
        if (this.isNotificationDisabled(user)) {
            TargetableNotificationPreferenceBuilder builder = (TargetableNotificationPreferenceBuilder)this.targetableNotificationPreferenceBuilderProvider.get();
            ArrayList<NotificationPreference> preferencesToCreate = new ArrayList<NotificationPreference>();
            Date now = new Date();
            for (String eventType : XWIKI_EVENT_TYPES) {
                for (NotificationFormat format : NotificationFormat.values()) {
                    preferencesToCreate.add(this.createNotificationPreference(user, builder, eventType, format, now));
                }
            }
            this.notificationPreferenceManager.savePreferences(preferencesToCreate);
        }
    }

    public boolean isNotificationDisabled(DocumentReference user) throws NotificationException {
        List<NotificationPreference> preferences = this.notificationPreferenceManager.getAllPreferences(user);
        return preferences.stream().noneMatch(pref -> pref.isNotificationEnabled() && XWIKI_EVENT_TYPES.contains(pref.getProperties().get((Object)NotificationPreferenceProperty.EVENT_TYPE)));
    }

    private TargetableNotificationPreference createNotificationPreference(DocumentReference user, TargetableNotificationPreferenceBuilder builder, String eventType, NotificationFormat format, Date date) {
        builder.prepare();
        builder.setCategory(NotificationPreferenceCategory.DEFAULT);
        builder.setEnabled(true);
        builder.setFormat(format);
        HashMap<NotificationPreferenceProperty, Object> properties = new HashMap<NotificationPreferenceProperty, Object>();
        properties.put(NotificationPreferenceProperty.EVENT_TYPE, eventType);
        builder.setProperties(properties);
        builder.setProviderHint("userProfile");
        builder.setStartDate(date);
        builder.setTarget((EntityReference)user);
        return builder.build();
    }
}

