/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.preferences.internal.email;

import java.util.Arrays;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.LocalDocumentReference;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.notifications.preferences.email.NotificationEmailDiffType;
import org.xwiki.notifications.preferences.email.NotificationEmailUserPreferenceManager;
import org.xwiki.text.StringUtils;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;

@Component
@Singleton
public class DefaultNotificationEmailUserPreferenceManager
implements NotificationEmailUserPreferenceManager {
    private static final String WIKI_SPACE = "XWiki";
    private static final String NOTIFICATIONS = "Notifications";
    private static final String CODE = "Code";
    private static final LocalDocumentReference EMAIL_PREFERENCES_CLASS = new LocalDocumentReference(Arrays.asList("XWiki", "Notifications", "Code"), "NotificationEmailPreferenceClass");
    private static final LocalDocumentReference GLOBAL_PREFERENCES = new LocalDocumentReference(Arrays.asList("XWiki", "Notifications", "Code"), "NotificationAdministration");
    private static final String DIFF_TYPE = "diffType";
    @Inject
    private DocumentAccessBridge documentAccessBridge;
    @Inject
    private DocumentReferenceResolver<String> referenceResolver;
    @Inject
    private WikiDescriptorManager wikiDescriptorManager;
    @Inject
    private Logger logger;

    @Override
    public NotificationEmailDiffType getDiffType() {
        return this.getDiffType(this.documentAccessBridge.getCurrentUserReference());
    }

    @Override
    public NotificationEmailDiffType getDiffType(String userId) {
        DocumentReference user = this.referenceResolver.resolve((Object)userId, new Object[0]);
        return this.getDiffType(user);
    }

    private NotificationEmailDiffType getDiffType(DocumentReference user) {
        try {
            DocumentReference emailClassReference = new DocumentReference(EMAIL_PREFERENCES_CLASS, user.getWikiReference());
            Object diffType = this.documentAccessBridge.getProperty(user, emailClassReference, DIFF_TYPE);
            if (diffType != null && StringUtils.isNotBlank((CharSequence)((String)diffType))) {
                return NotificationEmailDiffType.valueOf((String)diffType);
            }
            DocumentReference xwikiPref = new DocumentReference(GLOBAL_PREFERENCES, user.getWikiReference());
            diffType = this.documentAccessBridge.getProperty(xwikiPref, emailClassReference, DIFF_TYPE);
            if (diffType != null && StringUtils.isNotBlank((CharSequence)((String)diffType))) {
                return NotificationEmailDiffType.valueOf((String)diffType);
            }
            WikiReference mainWiki = new WikiReference(this.wikiDescriptorManager.getMainWikiId());
            if (!user.getWikiReference().equals((Object)mainWiki) && (diffType = this.documentAccessBridge.getProperty(xwikiPref = new DocumentReference(GLOBAL_PREFERENCES, mainWiki), emailClassReference = new DocumentReference(EMAIL_PREFERENCES_CLASS, mainWiki), DIFF_TYPE)) != null && StringUtils.isNotBlank((CharSequence)((String)diffType))) {
                return NotificationEmailDiffType.valueOf((String)diffType);
            }
        }
        catch (Exception e) {
            this.logger.warn("Failed to get the email diff type for the user [{}].", (Object)user, (Object)e);
        }
        return NotificationEmailDiffType.STANDARD;
    }
}

