/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.preferences.script;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.notifications.NotificationException;
import org.xwiki.notifications.NotificationFormat;
import org.xwiki.notifications.preferences.NotificationPreference;
import org.xwiki.notifications.preferences.NotificationPreferenceCategory;
import org.xwiki.notifications.preferences.NotificationPreferenceManager;
import org.xwiki.notifications.preferences.NotificationPreferenceProperty;
import org.xwiki.notifications.preferences.TargetableNotificationPreference;
import org.xwiki.notifications.preferences.TargetableNotificationPreferenceBuilder;
import org.xwiki.notifications.preferences.email.NotificationEmailDiffType;
import org.xwiki.notifications.preferences.email.NotificationEmailUserPreferenceManager;
import org.xwiki.script.service.ScriptService;
import org.xwiki.security.authorization.AccessDeniedException;
import org.xwiki.security.authorization.ContextualAuthorizationManager;
import org.xwiki.security.authorization.Right;
import org.xwiki.text.StringUtils;

@Component
@Named(value="notification.preferences")
@Singleton
public class NotificationPreferenceScriptService
implements ScriptService {
    @Inject
    private DocumentAccessBridge documentAccessBridge;
    @Inject
    private ContextualAuthorizationManager authorizationManager;
    @Inject
    private DocumentReferenceResolver<String> documentReferenceResolver;
    @Inject
    private NotificationPreferenceManager notificationPreferenceManager;
    @Inject
    private Provider<TargetableNotificationPreferenceBuilder> targetableNotificationPreferenceBuilderProvider;
    @Inject
    private NotificationEmailUserPreferenceManager emailUserPreferenceManager;

    private void saveNotificationPreferences(String json, String providerHint, EntityReference target, NotificationPreferenceCategory category) throws NotificationException {
        List<NotificationPreference> existingPreferences = Collections.emptyList();
        if (target instanceof DocumentReference) {
            existingPreferences = this.notificationPreferenceManager.getAllPreferences((DocumentReference)target);
        } else if (target instanceof WikiReference) {
            existingPreferences = this.notificationPreferenceManager.getAllPreferences((WikiReference)target);
        }
        TargetableNotificationPreferenceBuilder targetableNotificationPreferenceBuilder = (TargetableNotificationPreferenceBuilder)this.targetableNotificationPreferenceBuilderProvider.get();
        ArrayList<NotificationPreference> toSave = new ArrayList<NotificationPreference>();
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            List preferences = (List)objectMapper.reader().forType(List.class).readValue(json);
            for (Map item : preferences) {
                String eventType = (String)item.get("eventType");
                NotificationFormat format = NotificationFormat.valueOf((String)((String)item.get("format")).toUpperCase());
                boolean enabled = (Boolean)item.get("enabled");
                targetableNotificationPreferenceBuilder.prepare();
                targetableNotificationPreferenceBuilder.setEnabled(enabled);
                targetableNotificationPreferenceBuilder.setFormat(format);
                targetableNotificationPreferenceBuilder.setProviderHint(providerHint);
                targetableNotificationPreferenceBuilder.setProperties(Collections.singletonMap(NotificationPreferenceProperty.EVENT_TYPE, eventType));
                targetableNotificationPreferenceBuilder.setTarget(target);
                targetableNotificationPreferenceBuilder.setCategory(category);
                TargetableNotificationPreference newPreference = targetableNotificationPreferenceBuilder.build();
                NotificationPreference correspondingPreference = this.getCorrespondingPreference(existingPreferences, newPreference);
                if (correspondingPreference != null && correspondingPreference.isNotificationEnabled() == newPreference.isNotificationEnabled()) continue;
                toSave.add(newPreference);
            }
            this.notificationPreferenceManager.savePreferences(toSave);
        }
        catch (Exception e) {
            throw new NotificationException("Failed to save preferences for notifications given as JSON.", (Throwable)e);
        }
    }

    private NotificationPreference getCorrespondingPreference(List<NotificationPreference> existingPreferences, TargetableNotificationPreference newPreference) {
        for (NotificationPreference pref : existingPreferences) {
            if (!pref.equals(newPreference)) continue;
            return pref;
        }
        return null;
    }

    public void saveNotificationPreferences(String json, DocumentReference userReference) throws NotificationException, AccessDeniedException {
        this.authorizationManager.checkAccess(Right.EDIT, (EntityReference)userReference);
        this.saveNotificationPreferences(json, "userProfile", (EntityReference)userReference, NotificationPreferenceCategory.DEFAULT);
    }

    public void saveNotificationPreferences(String json) throws NotificationException {
        try {
            this.saveNotificationPreferences(json, this.documentAccessBridge.getCurrentUserReference());
        }
        catch (AccessDeniedException e) {
            throw new NotificationException(String.format("User [%s] has not the right to edit its own profile!", this.documentAccessBridge.getCurrentDocumentReference()), (Throwable)e);
        }
    }

    public void saveNotificationPreferencesForCurrentWiki(String json) throws NotificationException, AccessDeniedException {
        WikiReference currentWiki = this.documentAccessBridge.getCurrentDocumentReference().getWikiReference();
        this.authorizationManager.checkAccess(Right.ADMIN, (EntityReference)currentWiki);
        this.saveNotificationPreferences(json, "wiki", (EntityReference)currentWiki, NotificationPreferenceCategory.SYSTEM);
    }

    public void setStartDate(Date startDate) throws NotificationException {
        this.notificationPreferenceManager.setStartDateForUser(this.documentAccessBridge.getCurrentUserReference(), startDate);
    }

    public void setStartDate(String userId, Date startDate) throws NotificationException {
        try {
            DocumentReference user = this.documentReferenceResolver.resolve((Object)userId, new Object[0]);
            this.authorizationManager.checkAccess(Right.EDIT, (EntityReference)user);
            this.notificationPreferenceManager.setStartDateForUser(user, startDate);
        }
        catch (AccessDeniedException e) {
            throw new NotificationException(String.format("Unable to save the start date of the notifications for the user [%s]", userId), (Throwable)e);
        }
    }

    public boolean hasAnyEnabledNotificationPreferences() throws NotificationException {
        List<NotificationPreference> preferences = this.notificationPreferenceManager.getAllPreferences(this.documentAccessBridge.getCurrentUserReference());
        return preferences.stream().anyMatch(NotificationPreference::isNotificationEnabled);
    }

    public NotificationEmailDiffType getDiffType() {
        return this.emailUserPreferenceManager.getDiffType();
    }

    public NotificationEmailDiffType getDiffType(String userId) {
        return this.emailUserPreferenceManager.getDiffType(userId);
    }

    public boolean isEventTypeEnabled(String eventType, NotificationFormat format, String wiki) throws NotificationException, AccessDeniedException {
        WikiReference wikiReference = new WikiReference(wiki);
        this.authorizationManager.checkAccess(Right.ADMIN, (EntityReference)wikiReference);
        for (NotificationPreference preference : this.notificationPreferenceManager.getAllPreferences(wikiReference)) {
            Object prefEventType = preference.getProperties().get((Object)NotificationPreferenceProperty.EVENT_TYPE);
            if (prefEventType == null || !StringUtils.equals((CharSequence)((String)prefEventType), (CharSequence)eventType) || preference.getFormat() != format) continue;
            return preference.isNotificationEnabled();
        }
        return false;
    }

    public boolean isEventTypeEnabled(String eventType, NotificationFormat format) throws NotificationException {
        for (NotificationPreference preference : this.notificationPreferenceManager.getAllPreferences(this.documentAccessBridge.getCurrentUserReference())) {
            Object prefEventType = preference.getProperties().get((Object)NotificationPreferenceProperty.EVENT_TYPE);
            if (prefEventType == null || !StringUtils.equals((CharSequence)((String)prefEventType), (CharSequence)eventType) || preference.getFormat() != format) continue;
            return preference.isNotificationEnabled();
        }
        return false;
    }
}

