/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.preferences.internal;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.LocalDocumentReference;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.notifications.NotificationException;
import org.xwiki.notifications.NotificationFormat;
import org.xwiki.notifications.preferences.NotificationPreference;
import org.xwiki.notifications.preferences.NotificationPreferenceCategory;
import org.xwiki.notifications.preferences.NotificationPreferenceManager;
import org.xwiki.notifications.preferences.NotificationPreferenceProperty;
import org.xwiki.notifications.preferences.TargetableNotificationPreferenceBuilder;
import org.xwiki.notifications.preferences.internal.ModelBridge;
import org.xwiki.text.StringUtils;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;

@Component
@Singleton
public class DefaultModelBridge
implements ModelBridge {
    private static final String EVENT_TYPE_FIELD = "eventType";
    private static final String START_DATE_FIELD = "startDate";
    private static final String NOTIFICATION_ENABLED_FIELD = "notificationEnabled";
    private static final String FORMAT_FIELD = "format";
    private static final String WIKI_SPACE = "XWiki";
    private static final String NOTIFICATIONS = "Notifications";
    private static final String CODE = "Code";
    private static final String NOTIFICATION_PREFERENCE_CLASS_NAME = "NotificationPreferenceClass";
    public static final String NOTIFICATION_PREFERENCE_CLASS_STRING = "XWiki.Notifications.Code.NotificationPreferenceClass";
    private static final LocalDocumentReference NOTIFICATION_PREFERENCE_CLASS = new LocalDocumentReference(Arrays.asList("XWiki", "Notifications", "Code"), "NotificationPreferenceClass");
    private static final LocalDocumentReference GLOBAL_PREFERENCES = new LocalDocumentReference(Arrays.asList("XWiki", "Notifications", "Code"), "NotificationAdministration");
    private static final String NOTIFICATION_START_DATE_UPDATE_COMMENT = "Update start date for the notifications.";
    private static final String SET_USER_START_DATE_ERROR_MESSAGE = "Failed to set the user start date for [%s].";
    private static final String WIKI_PROVIDER = "wiki";
    @Inject
    private Provider<XWikiContext> contextProvider;
    @Inject
    private Provider<TargetableNotificationPreferenceBuilder> notificationPreferenceBuilderProvider;
    @Inject
    private WikiDescriptorManager wikiDescriptorManager;
    @Inject
    private Provider<NotificationPreferenceManager> notificationPreferenceManager;

    public List<NotificationPreference> getNotificationsPreferences(DocumentReference userReference) throws NotificationException {
        return this.getNotificationPreferences(userReference, "userProfile");
    }

    public List<NotificationPreference> getNotificationsPreferences(WikiReference wikiReference) throws NotificationException {
        List<NotificationPreference> results = this.getNotificationPreferences(new DocumentReference(GLOBAL_PREFERENCES, wikiReference), WIKI_PROVIDER);
        if (!wikiReference.getName().equals(this.wikiDescriptorManager.getMainWikiId())) {
            results.addAll(this.getNotificationsPreferences(new WikiReference(this.wikiDescriptorManager.getMainWikiId())));
        }
        return results;
    }

    private List<NotificationPreference> getNotificationPreferences(DocumentReference document, String providerHint) throws NotificationException {
        XWikiContext context = (XWikiContext)this.contextProvider.get();
        XWiki xwiki = context.getWiki();
        ArrayList<NotificationPreference> preferences = new ArrayList<NotificationPreference>();
        TargetableNotificationPreferenceBuilder notificationPreferenceBuilder = (TargetableNotificationPreferenceBuilder)this.notificationPreferenceBuilderProvider.get();
        try {
            XWikiDocument doc = xwiki.getDocument(document, context);
            List preferencesObj = doc.getXObjects((EntityReference)NOTIFICATION_PREFERENCE_CLASS);
            if (preferencesObj != null) {
                for (BaseObject obj : preferencesObj) {
                    if (obj == null) continue;
                    String objFormat = obj.getStringValue(FORMAT_FIELD);
                    Date objStartDate = obj.getDateValue(START_DATE_FIELD);
                    Map<NotificationPreferenceProperty, Object> properties = this.extractNotificationPreferenceProperties(obj);
                    notificationPreferenceBuilder.prepare();
                    notificationPreferenceBuilder.setProperties(properties);
                    notificationPreferenceBuilder.setStartDate(objStartDate != null ? objStartDate : doc.getCreationDate());
                    notificationPreferenceBuilder.setFormat(StringUtils.isNotBlank((CharSequence)objFormat) ? NotificationFormat.valueOf((String)objFormat.toUpperCase()) : NotificationFormat.ALERT);
                    notificationPreferenceBuilder.setTarget((EntityReference)document);
                    notificationPreferenceBuilder.setProviderHint(providerHint);
                    notificationPreferenceBuilder.setEnabled(obj.getIntValue(NOTIFICATION_ENABLED_FIELD, 0) != 0);
                    notificationPreferenceBuilder.setCategory(NotificationPreferenceCategory.DEFAULT);
                    preferences.add((NotificationPreference)notificationPreferenceBuilder.build());
                }
            }
        }
        catch (Exception e) {
            throw new NotificationException(String.format("Failed to get the notification preferences from the document [%s].", document), (Throwable)e);
        }
        return preferences;
    }

    private Map<NotificationPreferenceProperty, Object> extractNotificationPreferenceProperties(BaseObject object) {
        HashMap<NotificationPreferenceProperty, Object> properties = new HashMap<NotificationPreferenceProperty, Object>();
        String eventType = object.getStringValue(EVENT_TYPE_FIELD);
        if (StringUtils.isNotBlank((CharSequence)eventType)) {
            properties.put(NotificationPreferenceProperty.EVENT_TYPE, eventType);
        }
        return properties;
    }

    public void setStartDateForUser(DocumentReference userReference, Date startDate) throws NotificationException {
        List preferences = ((NotificationPreferenceManager)this.notificationPreferenceManager.get()).getAllPreferences(userReference);
        TargetableNotificationPreferenceBuilder notificationPreferenceBuilder = (TargetableNotificationPreferenceBuilder)this.notificationPreferenceBuilderProvider.get();
        ArrayList<NotificationPreference> toSave = new ArrayList<NotificationPreference>(preferences.size());
        for (NotificationPreference preference : preferences) {
            if (preference.getFormat() == NotificationFormat.EMAIL) continue;
            notificationPreferenceBuilder.prepare();
            notificationPreferenceBuilder.setCategory(preference.getCategory());
            notificationPreferenceBuilder.setEnabled(true);
            notificationPreferenceBuilder.setFormat(NotificationFormat.ALERT);
            notificationPreferenceBuilder.setProperties(preference.getProperties());
            notificationPreferenceBuilder.setProviderHint(preference.getProviderHint());
            notificationPreferenceBuilder.setTarget((EntityReference)userReference);
            notificationPreferenceBuilder.setStartDate(startDate);
            toSave.add((NotificationPreference)notificationPreferenceBuilder.build());
        }
        this.saveNotificationsPreferences(userReference, toSave);
    }

    private BaseObject findNotificationPreference(XWikiDocument xWikiDocument, NotificationPreference notificationPreference) throws NotificationException {
        List objects = xWikiDocument.getXObjects((EntityReference)NOTIFICATION_PREFERENCE_CLASS);
        if (objects != null) {
            for (BaseObject object : objects) {
                String format;
                if (object == null || !notificationPreference.getProperties().containsKey(NotificationPreferenceProperty.EVENT_TYPE) || !notificationPreference.getProperties().get(NotificationPreferenceProperty.EVENT_TYPE).equals(object.getStringValue(EVENT_TYPE_FIELD)) || (!StringUtils.isBlank((CharSequence)(format = object.getStringValue(FORMAT_FIELD))) || !notificationPreference.getFormat().equals((Object)NotificationFormat.ALERT)) && !notificationPreference.getFormat().equals((Object)NotificationFormat.valueOf((String)format.toUpperCase()))) continue;
                return object;
            }
        }
        return null;
    }

    public void saveNotificationsPreferences(DocumentReference targetDocument, List<NotificationPreference> notificationPreferences) throws NotificationException {
        try {
            XWikiContext context = (XWikiContext)this.contextProvider.get();
            XWiki xwiki = context.getWiki();
            XWikiDocument document = xwiki.getDocument(targetDocument, context);
            for (NotificationPreference notificationPreference : notificationPreferences) {
                if (!notificationPreference.getProperties().containsKey(NotificationPreferenceProperty.EVENT_TYPE)) continue;
                BaseObject preferenceObject = this.findNotificationPreference(document, notificationPreference);
                if (preferenceObject == null) {
                    preferenceObject = new BaseObject();
                    preferenceObject.setXClassReference((EntityReference)NOTIFICATION_PREFERENCE_CLASS);
                    document.addXObject(preferenceObject);
                }
                preferenceObject.set(EVENT_TYPE_FIELD, notificationPreference.getProperties().get(NotificationPreferenceProperty.EVENT_TYPE), context);
                preferenceObject.set(FORMAT_FIELD, (Object)notificationPreference.getFormat().name().toLowerCase(), context);
                preferenceObject.set(NOTIFICATION_ENABLED_FIELD, (Object)(notificationPreference.isNotificationEnabled() ? 1 : 0), context);
                Date startDate = null;
                if (notificationPreference.isNotificationEnabled() && (startDate = notificationPreference.getStartDate()) == null && (startDate = preferenceObject.getDateValue(START_DATE_FIELD)) == null) {
                    startDate = new Date();
                }
                preferenceObject.set(START_DATE_FIELD, (Object)startDate, context);
            }
            xwiki.saveDocument(document, "Update notification preferences.", true, context);
        }
        catch (XWikiException e) {
            throw new NotificationException(String.format("Failed to save the notification preference into [%s]", targetDocument));
        }
    }
}

