/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.rest.internal;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.notifications.CompositeEvent;
import org.xwiki.notifications.CompositeEventStatus;
import org.xwiki.notifications.CompositeEventStatusManager;
import org.xwiki.notifications.notifiers.NotificationRenderer;
import org.xwiki.notifications.rest.model.Notification;
import org.xwiki.rendering.renderer.BlockRenderer;
import org.xwiki.rendering.renderer.printer.DefaultWikiPrinter;
import org.xwiki.rendering.renderer.printer.WikiPrinter;
import org.xwiki.text.StringUtils;

@Component(roles={InternalNotificationsRenderer.class})
@Singleton
public class InternalNotificationsRenderer {
    @Inject
    private CompositeEventStatusManager compositeEventStatusManager;
    @Inject
    private ComponentManager componentManager;
    @Inject
    private EntityReferenceSerializer<String> entityReferenceSerializer;
    @Inject
    private NotificationRenderer notificationRenderer;
    @Inject
    private Logger logger;

    public List<Notification> renderNotifications(List<CompositeEvent> compositeEvents, String userId, boolean showReadStatus) throws Exception {
        ArrayList<Notification> notifications = new ArrayList<Notification>();
        if (showReadStatus && StringUtils.isNotBlank((CharSequence)userId)) {
            for (CompositeEventStatus status : this.compositeEventStatusManager.getCompositeEventStatuses(compositeEvents, userId)) {
                notifications.add(this.toNotification(status.getCompositeEvent(), status.getStatus()));
            }
        } else {
            for (CompositeEvent event : compositeEvents) {
                notifications.add(this.toNotification(event, null));
            }
        }
        return notifications;
    }

    private Notification toNotification(CompositeEvent event, Boolean status) {
        String html = null;
        String exception = null;
        try {
            html = this.render(event);
        }
        catch (Exception e) {
            this.logger.error("Error while rendering notification", (Throwable)e);
            exception = e.toString();
        }
        return new Notification(event, status, html, exception, this.entityReferenceSerializer);
    }

    private String render(CompositeEvent compositeEvent) throws Exception {
        DefaultWikiPrinter printer = new DefaultWikiPrinter();
        BlockRenderer renderer = (BlockRenderer)this.componentManager.getInstance(BlockRenderer.class, "html/5.0");
        renderer.render(this.notificationRenderer.render(compositeEvent), (WikiPrinter)printer);
        return printer.toString();
    }
}

