/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.sources.internal;

import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.notifications.CompositeEvent;
import org.xwiki.notifications.NotificationException;
import org.xwiki.notifications.NotificationFormat;
import org.xwiki.notifications.filters.NotificationFilterManager;
import org.xwiki.notifications.filters.NotificationFilterPreferenceManager;
import org.xwiki.notifications.preferences.NotificationPreference;
import org.xwiki.notifications.preferences.NotificationPreferenceManager;
import org.xwiki.notifications.sources.NotificationManager;
import org.xwiki.notifications.sources.NotificationParameters;
import org.xwiki.notifications.sources.ParametrizedNotificationManager;

@Component
@Singleton
public class DefaultNotificationManager
implements NotificationManager {
    @Inject
    private DocumentAccessBridge documentAccessBridge;
    @Inject
    private DocumentReferenceResolver<String> documentReferenceResolver;
    @Inject
    private NotificationPreferenceManager notificationPreferenceManager;
    @Inject
    private NotificationFilterManager notificationFilterManager;
    @Inject
    private NotificationFilterPreferenceManager notificationFilterPreferenceManager;
    @Inject
    private ParametrizedNotificationManager parametrizedNotificationManager;

    @Override
    public List<CompositeEvent> getEvents(String userId, int expectedCount) throws NotificationException {
        NotificationParameters parameters = new NotificationParameters();
        parameters.user = this.documentReferenceResolver.resolve((Object)userId, new Object[0]);
        parameters.format = NotificationFormat.ALERT;
        parameters.expectedCount = expectedCount;
        return this.getEvents(parameters);
    }

    @Override
    public List<CompositeEvent> getEvents(String userId, int count, Date untilDate, List<String> blackList) throws NotificationException {
        NotificationParameters parameters = new NotificationParameters();
        parameters.user = this.documentReferenceResolver.resolve((Object)userId, new Object[0]);
        parameters.format = NotificationFormat.ALERT;
        parameters.expectedCount = count;
        parameters.endDate = untilDate;
        parameters.blackList = blackList;
        return this.getEvents(parameters);
    }

    @Override
    public List<CompositeEvent> getEvents(String userId, int expectedCount, Date untilDate, Date fromDate, List<String> blackList) throws NotificationException {
        NotificationParameters parameters = new NotificationParameters();
        parameters.user = this.documentReferenceResolver.resolve((Object)userId, new Object[0]);
        parameters.format = NotificationFormat.ALERT;
        parameters.expectedCount = expectedCount;
        parameters.endDate = untilDate;
        parameters.fromDate = fromDate;
        parameters.blackList = blackList;
        return this.getEvents(parameters);
    }

    @Override
    public List<CompositeEvent> getEvents(String userId, NotificationFormat format, int expectedCount, Date untilDate, Date fromDate, List<String> blackList) throws NotificationException {
        NotificationParameters parameters = new NotificationParameters();
        parameters.user = this.documentReferenceResolver.resolve((Object)userId, new Object[0]);
        parameters.format = format;
        parameters.expectedCount = expectedCount;
        parameters.endDate = untilDate;
        parameters.fromDate = fromDate;
        parameters.blackList = blackList;
        return this.getEvents(parameters);
    }

    @Override
    public long getEventsCount(String userId, int maxCount) throws NotificationException {
        NotificationParameters parameters = new NotificationParameters();
        parameters.user = this.documentReferenceResolver.resolve((Object)userId, new Object[0]);
        parameters.format = NotificationFormat.ALERT;
        parameters.expectedCount = maxCount;
        parameters.onlyUnread = true;
        return this.getEvents(parameters).size();
    }

    private List<CompositeEvent> getEvents(NotificationParameters parameters) throws NotificationException {
        parameters.preferences = this.notificationPreferenceManager.getPreferences(parameters.user, true, parameters.format);
        parameters.filters = this.notificationFilterManager.getAllFilters(parameters.user, true);
        parameters.filterPreferences = this.notificationFilterPreferenceManager.getFilterPreferences(parameters.user);
        return this.parametrizedNotificationManager.getEvents(parameters);
    }

    @Override
    public List<NotificationPreference> getPreferences() throws NotificationException {
        return this.notificationPreferenceManager.getAllPreferences(this.documentAccessBridge.getCurrentUserReference());
    }

    @Override
    public List<NotificationPreference> getPreferences(String userId) throws NotificationException {
        return this.notificationPreferenceManager.getAllPreferences(this.documentReferenceResolver.resolve((Object)userId, new Object[0]));
    }

    @Override
    public void setStartDate(String userId, Date startDate) throws NotificationException {
        this.notificationPreferenceManager.setStartDateForUser(this.documentReferenceResolver.resolve((Object)userId, new Object[0]), startDate);
    }
}

