/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.sources.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.eventstream.EventStreamException;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.LocalDocumentReference;
import org.xwiki.notifications.filters.NotificationFilter;
import org.xwiki.notifications.filters.NotificationFilterManager;
import org.xwiki.notifications.filters.NotificationFilterPreference;
import org.xwiki.notifications.filters.NotificationFilterType;
import org.xwiki.notifications.filters.expression.AndNode;
import org.xwiki.notifications.filters.expression.BooleanValueNode;
import org.xwiki.notifications.filters.expression.DateValueNode;
import org.xwiki.notifications.filters.expression.EntityReferenceNode;
import org.xwiki.notifications.filters.expression.EqualsNode;
import org.xwiki.notifications.filters.expression.EventProperty;
import org.xwiki.notifications.filters.expression.ExpressionNode;
import org.xwiki.notifications.filters.expression.GreaterThanNode;
import org.xwiki.notifications.filters.expression.InNode;
import org.xwiki.notifications.filters.expression.LesserThanNode;
import org.xwiki.notifications.filters.expression.NotEqualsNode;
import org.xwiki.notifications.filters.expression.NotNode;
import org.xwiki.notifications.filters.expression.PropertyValueNode;
import org.xwiki.notifications.filters.expression.StringValueNode;
import org.xwiki.notifications.filters.expression.generics.AbstractOperatorNode;
import org.xwiki.notifications.filters.expression.generics.AbstractValueNode;
import org.xwiki.notifications.filters.expression.generics.ExpressionBuilder;
import org.xwiki.notifications.preferences.NotificationPreference;
import org.xwiki.notifications.preferences.NotificationPreferenceProperty;
import org.xwiki.notifications.sources.NotificationParameters;
import org.xwiki.notifications.sources.internal.ExpressionNodeToHQLConverter;
import org.xwiki.notifications.sources.internal.OrderByNode;
import org.xwiki.notifications.sources.internal.RecordableEventDescriptorHelper;
import org.xwiki.query.Query;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryManager;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;

@Component(roles={QueryGenerator.class})
@Singleton
public class QueryGenerator {
    private static final LocalDocumentReference USER_CLASS = new LocalDocumentReference("XWiki", "XWikiUsers");
    @Inject
    private DocumentAccessBridge documentAccessBridge;
    @Inject
    private QueryManager queryManager;
    @Inject
    private ExpressionNodeToHQLConverter hqlConverter;
    @Inject
    private WikiDescriptorManager wikiDescriptorManager;
    @Inject
    private NotificationFilterManager notificationFilterManager;
    @Inject
    private RecordableEventDescriptorHelper recordableEventDescriptorHelper;

    public Query generateQuery(NotificationParameters parameters) throws QueryException, EventStreamException {
        ExpressionNodeToHQLConverter.HQLQuery result = this.hqlConverter.parse(this.generateQueryExpression(parameters));
        if (result.getQuery().isEmpty()) {
            return null;
        }
        Query query = this.queryManager.createQuery(String.format("where %s", result.getQuery()), "hql");
        for (Map.Entry<String, Object> queryParameter : result.getQueryParameters().entrySet()) {
            query.bindValue(queryParameter.getKey(), queryParameter.getValue());
        }
        return query;
    }

    public ExpressionNode generateQueryExpression(NotificationParameters parameters) throws EventStreamException {
        AbstractOperatorNode globalExclusiveFiltersNode;
        Collection<NotificationPreference> preferences = parameters.preferences;
        if (preferences.isEmpty() && parameters.filterPreferences.stream().noneMatch(NotificationFilterPreference::isActive)) {
            return null;
        }
        Object topNode = null;
        if (parameters.fromDate != null) {
            topNode = new GreaterThanNode((AbstractValueNode)new PropertyValueNode(EventProperty.DATE), (AbstractValueNode)new DateValueNode(parameters.fromDate));
        }
        Object preferencesNode = this.handleEventPreferences(parameters);
        AbstractOperatorNode globalInclusiveFiltersNode = this.handleInclusiveGlobalFilters(parameters);
        if (globalInclusiveFiltersNode != null) {
            preferencesNode = preferencesNode == null ? globalInclusiveFiltersNode : preferencesNode.or(globalInclusiveFiltersNode);
        }
        if (preferencesNode != null && (globalExclusiveFiltersNode = this.handleExclusiveGlobalFilters(parameters)) != null) {
            preferencesNode = preferencesNode.and(globalExclusiveFiltersNode);
        }
        if (preferencesNode != null) {
            topNode = topNode != null ? topNode.and(preferencesNode) : preferencesNode;
        }
        topNode = this.handleBlackList(parameters, (AbstractOperatorNode)topNode);
        topNode = this.handleEndDate(parameters, (AbstractOperatorNode)topNode);
        topNode = this.handleHiddenEvents(parameters, (AbstractOperatorNode)topNode);
        topNode = this.handleWiki(parameters, (AbstractOperatorNode)topNode);
        topNode = this.handleOrder((AbstractOperatorNode)topNode);
        return topNode;
    }

    private AbstractOperatorNode handleEventPreferences(NotificationParameters parameters) throws EventStreamException {
        AndNode preferencesNode = null;
        Iterator it = parameters.preferences.stream().filter(pref -> pref.getProperties().containsKey(NotificationPreferenceProperty.EVENT_TYPE)).iterator();
        while (it.hasNext()) {
            NotificationPreference preference = (NotificationPreference)it.next();
            if (!this.recordableEventDescriptorHelper.hasDescriptor((String)preference.getProperties().get(NotificationPreferenceProperty.EVENT_TYPE), parameters.user)) continue;
            AndNode preferenceTypeNode = new AndNode((AbstractOperatorNode)new EqualsNode((AbstractValueNode)ExpressionBuilder.value((EventProperty)EventProperty.TYPE), (AbstractValueNode)ExpressionBuilder.value((String)((String)preference.getProperties().get(NotificationPreferenceProperty.EVENT_TYPE)))), (AbstractOperatorNode)new GreaterThanNode((AbstractValueNode)ExpressionBuilder.value((EventProperty)EventProperty.DATE), (AbstractValueNode)ExpressionBuilder.value((Date)preference.getStartDate())));
            Iterator filterIterator = this.notificationFilterManager.getFiltersRelatedToNotificationPreference(parameters.filters, preference).iterator();
            while (filterIterator.hasNext()) {
                NotificationFilter filter = (NotificationFilter)filterIterator.next();
                ExpressionNode node = filter.filterExpression(parameters.user, parameters.filterPreferences, preference);
                if (node == null || !(node instanceof AbstractOperatorNode)) continue;
                preferenceTypeNode = preferenceTypeNode.and((AbstractOperatorNode)node);
            }
            if (preferencesNode == null) {
                preferencesNode = preferenceTypeNode;
                continue;
            }
            preferencesNode = preferencesNode.or((AbstractOperatorNode)preferenceTypeNode);
        }
        return preferencesNode;
    }

    private AbstractOperatorNode handleExclusiveGlobalFilters(NotificationParameters parameters) {
        AbstractOperatorNode globalFiltersNode = null;
        for (NotificationFilter filter : parameters.filters) {
            ExpressionNode node = filter.filterExpression(parameters.user, parameters.filterPreferences, NotificationFilterType.EXCLUSIVE, parameters.format);
            if (node == null || !(node instanceof AbstractOperatorNode)) continue;
            if (globalFiltersNode == null) {
                globalFiltersNode = (AbstractOperatorNode)node;
                continue;
            }
            globalFiltersNode = globalFiltersNode.and((AbstractOperatorNode)node);
        }
        return globalFiltersNode;
    }

    private AbstractOperatorNode handleInclusiveGlobalFilters(NotificationParameters parameters) {
        AbstractOperatorNode globalFiltersNode = null;
        for (NotificationFilter filter : parameters.filters) {
            ExpressionNode node = filter.filterExpression(parameters.user, parameters.filterPreferences, NotificationFilterType.INCLUSIVE, parameters.format, parameters.preferences);
            if (node == null || !(node instanceof AbstractOperatorNode)) continue;
            if (globalFiltersNode == null) {
                globalFiltersNode = (AbstractOperatorNode)node;
                continue;
            }
            globalFiltersNode = globalFiltersNode.or((AbstractOperatorNode)node);
        }
        return globalFiltersNode;
    }

    private AbstractOperatorNode handleEndDate(NotificationParameters parameters, AbstractOperatorNode topNode) {
        if (parameters.endDate != null) {
            return topNode.and((AbstractOperatorNode)new LesserThanNode((AbstractValueNode)new PropertyValueNode(EventProperty.DATE), (AbstractValueNode)new DateValueNode(parameters.endDate)));
        }
        return topNode;
    }

    private AbstractOperatorNode handleBlackList(NotificationParameters parameters, AbstractOperatorNode topNode) {
        if (parameters.blackList != null && !parameters.blackList.isEmpty()) {
            ArrayList<StringValueNode> values = new ArrayList<StringValueNode>();
            for (String value : parameters.blackList) {
                values.add(new StringValueNode(value));
            }
            NotNode node = new NotNode((AbstractOperatorNode)new InNode((AbstractValueNode)new PropertyValueNode(EventProperty.ID), values));
            if (topNode != null) {
                return topNode.and((AbstractOperatorNode)node);
            }
            return node;
        }
        return topNode;
    }

    private AbstractOperatorNode handleWiki(NotificationParameters parameters, AbstractOperatorNode topNode) {
        if (parameters.user != null && !parameters.user.getWikiReference().getName().equals(this.wikiDescriptorManager.getMainWikiId())) {
            EqualsNode node = new EqualsNode((AbstractValueNode)new PropertyValueNode(EventProperty.WIKI), (AbstractValueNode)new EntityReferenceNode((EntityReference)parameters.user.getWikiReference()));
            if (topNode != null) {
                return topNode.and((AbstractOperatorNode)node);
            }
            return node;
        }
        return topNode;
    }

    private AbstractOperatorNode handleOrder(AbstractOperatorNode topNode) {
        if (topNode != null) {
            return new OrderByNode(topNode, new PropertyValueNode(EventProperty.DATE), OrderByNode.Order.DESC);
        }
        return null;
    }

    private AbstractOperatorNode handleHiddenEvents(NotificationParameters parameters, AbstractOperatorNode topNode) {
        if (parameters.user == null) {
            return this.excludeHiddenEvents(topNode);
        }
        DocumentReference userClass = new DocumentReference(USER_CLASS, parameters.user.getWikiReference());
        Object displayHiddenDocuments = this.documentAccessBridge.getProperty(parameters.user, userClass, "displayHiddenDocuments");
        if (displayHiddenDocuments == null || Integer.valueOf(0).equals(displayHiddenDocuments)) {
            return this.excludeHiddenEvents(topNode);
        }
        return topNode;
    }

    private AbstractOperatorNode excludeHiddenEvents(AbstractOperatorNode topNode) {
        NotEqualsNode node = new NotEqualsNode((AbstractValueNode)new PropertyValueNode(EventProperty.HIDDEN), (AbstractValueNode)new BooleanValueNode(true));
        if (topNode != null) {
            return topNode.and((AbstractOperatorNode)node);
        }
        return node;
    }
}

