/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.sources.internal;

import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;
import org.xwiki.eventstream.EventStreamException;
import org.xwiki.eventstream.RecordableEventDescriptor;
import org.xwiki.eventstream.RecordableEventDescriptorManager;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.text.StringUtils;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;

@Component(roles={RecordableEventDescriptorHelper.class})
@Singleton
public class RecordableEventDescriptorHelper {
    private static final String CONTEXT_KEY = "RecordableEventDescriptorHelperCache_";
    @Inject
    private WikiDescriptorManager wikiDescriptorManager;
    @Inject
    private RecordableEventDescriptorManager recordableEventDescriptorManager;
    @Inject
    private Execution execution;

    private boolean isGlobalUser(DocumentReference user) {
        return user != null ? this.wikiDescriptorManager.getMainWikiId().equals(user.getWikiReference().getName()) : false;
    }

    public boolean hasDescriptor(String eventType, DocumentReference user) throws EventStreamException {
        return this.getRecordableEventDescriptor(user).stream().anyMatch(descriptor -> StringUtils.equals((CharSequence)eventType, (CharSequence)descriptor.getEventType()));
    }

    private Collection<RecordableEventDescriptor> getRecordableEventDescriptor(DocumentReference user) throws EventStreamException {
        String contextKey = CONTEXT_KEY + user;
        ExecutionContext context = this.execution.getContext();
        if (context.hasProperty(contextKey)) {
            return (Collection)context.getProperty(contextKey);
        }
        List descriptors = this.recordableEventDescriptorManager.getRecordableEventDescriptors(this.isGlobalUser(user));
        context.setProperty(contextKey, (Object)descriptors);
        return descriptors;
    }
}

