/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.observation.remote.internal;

import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;
import org.xwiki.context.ExecutionContextManager;
import org.xwiki.observation.ObservationManager;
import org.xwiki.observation.event.ApplicationStoppedEvent;
import org.xwiki.observation.remote.LocalEventData;
import org.xwiki.observation.remote.NetworkAdapter;
import org.xwiki.observation.remote.RemoteEventData;
import org.xwiki.observation.remote.RemoteEventException;
import org.xwiki.observation.remote.RemoteObservationManager;
import org.xwiki.observation.remote.RemoteObservationManagerConfiguration;
import org.xwiki.observation.remote.RemoteObservationManagerContext;
import org.xwiki.observation.remote.converter.EventConverterManager;

@Component
@Singleton
public class DefaultRemoteObservationManager
implements RemoteObservationManager,
Initializable {
    @Inject
    private RemoteObservationManagerConfiguration configuration;
    @Inject
    private EventConverterManager eventConverterManager;
    @Inject
    private ObservationManager observationManager;
    @Inject
    private RemoteObservationManagerContext remoteEventManagerContext;
    @Inject
    private Execution execution;
    @Inject
    private ExecutionContextManager executionContextManager;
    @Inject
    private ComponentManager componentManager;
    @Inject
    private Logger logger;
    private NetworkAdapter networkAdapter;

    public void initialize() throws InitializationException {
        try {
            String networkAdapterHint = this.configuration.getNetworkAdapter();
            this.networkAdapter = (NetworkAdapter)this.componentManager.getInstance(NetworkAdapter.class, networkAdapterHint);
        }
        catch (ComponentLookupException e) {
            throw new InitializationException("Failed to initialize network adapter [" + this.configuration.getNetworkAdapter() + "]", (Throwable)e);
        }
        for (String channelId : this.configuration.getChannels()) {
            try {
                this.startChannel(channelId);
            }
            catch (RemoteEventException e) {
                this.logger.error("Failed to start channel [" + channelId + "]", (Throwable)e);
            }
        }
    }

    @Override
    public void notify(LocalEventData localEvent) {
        if (this.remoteEventManagerContext.isRemoteState()) {
            return;
        }
        RemoteEventData remoteEvent = this.eventConverterManager.createRemoteEventData(localEvent);
        if (remoteEvent != null) {
            this.networkAdapter.send(remoteEvent);
        }
        if (localEvent.getEvent() instanceof ApplicationStoppedEvent) {
            try {
                this.networkAdapter.stopAllChannels();
            }
            catch (RemoteEventException e) {
                this.logger.error("Failed to stop channels", (Throwable)e);
            }
        }
    }

    @Override
    public void notify(RemoteEventData remoteEvent) {
        this.initializeContext();
        LocalEventData localEvent = this.eventConverterManager.createLocalEventData(remoteEvent);
        if (localEvent != null) {
            this.remoteEventManagerContext.pushRemoteState();
            try {
                this.observationManager.notify(localEvent.getEvent(), localEvent.getSource(), localEvent.getData());
            }
            finally {
                this.remoteEventManagerContext.popRemoteState();
            }
        }
    }

    @Override
    public void startChannel(String channelId) throws RemoteEventException {
        this.networkAdapter.startChannel(channelId);
    }

    @Override
    public void stopChannel(String channelId) throws RemoteEventException {
        this.networkAdapter.stopChannel(channelId);
    }

    private void initializeContext() {
        if (this.execution.getContext() == null) {
            ExecutionContext context = new ExecutionContext();
            try {
                this.executionContextManager.initialize(context);
            }
            catch (Exception e) {
                this.logger.error("failed to initialize execution context", (Throwable)e);
            }
        }
    }
}

