/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.observation.remote.internal.converter;

import java.io.Serializable;
import org.xwiki.component.annotation.Component;
import org.xwiki.observation.event.Event;
import org.xwiki.observation.remote.LocalEventData;
import org.xwiki.observation.remote.RemoteEventData;
import org.xwiki.observation.remote.converter.AbstractEventConverter;

@Component
public class SerializableEventConverter
extends AbstractEventConverter {
    public int getPriority() {
        return 2000;
    }

    public boolean fromRemote(RemoteEventData remoteEvent, LocalEventData localEvent) {
        if (remoteEvent.getEvent() instanceof Event) {
            localEvent.setEvent((Event)remoteEvent.getEvent());
            if (remoteEvent.getSource() != null) {
                localEvent.setSource(remoteEvent.getSource());
            }
            if (remoteEvent.getData() != null) {
                localEvent.setData(remoteEvent.getData());
            }
            return true;
        }
        return false;
    }

    public boolean toRemote(LocalEventData localEvent, RemoteEventData remoteEvent) {
        if (this.isSerializable(localEvent)) {
            remoteEvent.setEvent((Serializable)localEvent.getEvent());
            remoteEvent.setSource((Serializable)localEvent.getSource());
            remoteEvent.setData((Serializable)localEvent.getData());
            return true;
        }
        return false;
    }

    private boolean isSerializable(LocalEventData localEvent) {
        return localEvent.getEvent() instanceof Serializable && this.isSerializable(localEvent.getData()) && this.isSerializable(localEvent.getSource());
    }

    private boolean isSerializable(Object obj) {
        return obj instanceof Serializable || obj == null;
    }
}

