/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.observation.remote.internal.converter;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.observation.remote.LocalEventData;
import org.xwiki.observation.remote.RemoteEventData;
import org.xwiki.observation.remote.converter.EventConverterManager;
import org.xwiki.observation.remote.converter.LocalEventConverter;
import org.xwiki.observation.remote.converter.RemoteEventConverter;

@Component
@Singleton
public class DefaultEventConverterManager
implements EventConverterManager,
Initializable {
    @Inject
    private List<LocalEventConverter> localEventConverters;
    @Inject
    private List<RemoteEventConverter> remoteEventConverters;

    public void initialize() throws InitializationException {
        Collections.sort(this.localEventConverters, new Comparator<LocalEventConverter>(){

            @Override
            public int compare(LocalEventConverter eventConverter1, LocalEventConverter eventConverter2) {
                return eventConverter1.getPriority() - eventConverter2.getPriority();
            }
        });
        Collections.sort(this.remoteEventConverters, new Comparator<RemoteEventConverter>(){

            @Override
            public int compare(RemoteEventConverter eventConverter1, RemoteEventConverter eventConverter2) {
                return eventConverter1.getPriority() - eventConverter2.getPriority();
            }
        });
    }

    @Override
    public List<LocalEventConverter> getLocalEventConverters() {
        return this.localEventConverters;
    }

    @Override
    public List<RemoteEventConverter> getRemoteEventConverters() {
        return this.remoteEventConverters;
    }

    @Override
    public RemoteEventData createRemoteEventData(LocalEventData localEvent) {
        RemoteEventData remoteEvent = new RemoteEventData();
        for (LocalEventConverter eventConverter : this.localEventConverters) {
            if (eventConverter.toRemote(localEvent, remoteEvent)) break;
        }
        if (remoteEvent.getEvent() == null) {
            remoteEvent = null;
        }
        return remoteEvent;
    }

    @Override
    public LocalEventData createLocalEventData(RemoteEventData remoteEvent) {
        LocalEventData localEvent = new LocalEventData();
        for (RemoteEventConverter eventConverter : this.remoteEventConverters) {
            if (eventConverter.fromRemote(remoteEvent, localEvent)) break;
        }
        if (localEvent.getEvent() == null) {
            localEvent = null;
        }
        return localEvent;
    }
}

