/* This file was generated by SableCC (http://www.sablecc.org/). */

package org.xwiki.query.internal.jpql.lexer;

import java.io.*;
import org.xwiki.query.internal.jpql.node.*;

@SuppressWarnings("nls")
public class Lexer
{
    protected Token token;
    protected State state = State.INITIAL;

    private PushbackReader in;
    private int line;
    private int pos;
    private boolean cr;
    private boolean eof;
    private final StringBuffer text = new StringBuffer();

    @SuppressWarnings("unused")
    protected void filter() throws LexerException, IOException
    {
        // Do nothing
    }

    public Lexer(@SuppressWarnings("hiding") PushbackReader in)
    {
        this.in = in;
    }
 
    public Token peek() throws LexerException, IOException
    {
        while(this.token == null)
        {
            this.token = getToken();
            filter();
        }

        return this.token;
    }

    public Token next() throws LexerException, IOException
    {
        while(this.token == null)
        {
            this.token = getToken();
            filter();
        }

        Token result = this.token;
        this.token = null;
        return result;
    }

    protected Token getToken() throws IOException, LexerException
    {
        int dfa_state = 0;

        int start_pos = this.pos;
        int start_line = this.line;

        int accept_state = -1;
        int accept_token = -1;
        int accept_length = -1;
        int accept_pos = -1;
        int accept_line = -1;

        @SuppressWarnings("hiding") int[][][] gotoTable = Lexer.gotoTable[this.state.id()];
        @SuppressWarnings("hiding") int[] accept = Lexer.accept[this.state.id()];
        this.text.setLength(0);

        while(true)
        {
            int c = getChar();

            if(c != -1)
            {
                switch(c)
                {
                case 10:
                    if(this.cr)
                    {
                        this.cr = false;
                    }
                    else
                    {
                        this.line++;
                        this.pos = 0;
                    }
                    break;
                case 13:
                    this.line++;
                    this.pos = 0;
                    this.cr = true;
                    break;
                default:
                    this.pos++;
                    this.cr = false;
                    break;
                }

                this.text.append((char) c);

                do
                {
                    int oldState = (dfa_state < -1) ? (-2 -dfa_state) : dfa_state;

                    dfa_state = -1;

                    int[][] tmp1 =  gotoTable[oldState];
                    int low = 0;
                    int high = tmp1.length - 1;

                    while(low <= high)
                    {
                        int middle = (low + high) / 2;
                        int[] tmp2 = tmp1[middle];

                        if(c < tmp2[0])
                        {
                            high = middle - 1;
                        }
                        else if(c > tmp2[1])
                        {
                            low = middle + 1;
                        }
                        else
                        {
                            dfa_state = tmp2[2];
                            break;
                        }
                    }
                }while(dfa_state < -1);
            }
            else
            {
                dfa_state = -1;
            }

            if(dfa_state >= 0)
            {
                if(accept[dfa_state] != -1)
                {
                    accept_state = dfa_state;
                    accept_token = accept[dfa_state];
                    accept_length = this.text.length();
                    accept_pos = this.pos;
                    accept_line = this.line;
                }
            }
            else
            {
                if(accept_state != -1)
                {
                    switch(accept_token)
                    {
                    case 0:
                        {
                            @SuppressWarnings("hiding") Token token = new0(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 1:
                        {
                            @SuppressWarnings("hiding") Token token = new1(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 2:
                        {
                            @SuppressWarnings("hiding") Token token = new2(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 3:
                        {
                            @SuppressWarnings("hiding") Token token = new3(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 4:
                        {
                            @SuppressWarnings("hiding") Token token = new4(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 5:
                        {
                            @SuppressWarnings("hiding") Token token = new5(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 6:
                        {
                            @SuppressWarnings("hiding") Token token = new6(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 7:
                        {
                            @SuppressWarnings("hiding") Token token = new7(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 8:
                        {
                            @SuppressWarnings("hiding") Token token = new8(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 9:
                        {
                            @SuppressWarnings("hiding") Token token = new9(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 10:
                        {
                            @SuppressWarnings("hiding") Token token = new10(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 11:
                        {
                            @SuppressWarnings("hiding") Token token = new11(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 12:
                        {
                            @SuppressWarnings("hiding") Token token = new12(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 13:
                        {
                            @SuppressWarnings("hiding") Token token = new13(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 14:
                        {
                            @SuppressWarnings("hiding") Token token = new14(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 15:
                        {
                            @SuppressWarnings("hiding") Token token = new15(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 16:
                        {
                            @SuppressWarnings("hiding") Token token = new16(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 17:
                        {
                            @SuppressWarnings("hiding") Token token = new17(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 18:
                        {
                            @SuppressWarnings("hiding") Token token = new18(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 19:
                        {
                            @SuppressWarnings("hiding") Token token = new19(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 20:
                        {
                            @SuppressWarnings("hiding") Token token = new20(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 21:
                        {
                            @SuppressWarnings("hiding") Token token = new21(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 22:
                        {
                            @SuppressWarnings("hiding") Token token = new22(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 23:
                        {
                            @SuppressWarnings("hiding") Token token = new23(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 24:
                        {
                            @SuppressWarnings("hiding") Token token = new24(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 25:
                        {
                            @SuppressWarnings("hiding") Token token = new25(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 26:
                        {
                            @SuppressWarnings("hiding") Token token = new26(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 27:
                        {
                            @SuppressWarnings("hiding") Token token = new27(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 28:
                        {
                            @SuppressWarnings("hiding") Token token = new28(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 29:
                        {
                            @SuppressWarnings("hiding") Token token = new29(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 30:
                        {
                            @SuppressWarnings("hiding") Token token = new30(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 31:
                        {
                            @SuppressWarnings("hiding") Token token = new31(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 32:
                        {
                            @SuppressWarnings("hiding") Token token = new32(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 33:
                        {
                            @SuppressWarnings("hiding") Token token = new33(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 34:
                        {
                            @SuppressWarnings("hiding") Token token = new34(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 35:
                        {
                            @SuppressWarnings("hiding") Token token = new35(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 36:
                        {
                            @SuppressWarnings("hiding") Token token = new36(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 37:
                        {
                            @SuppressWarnings("hiding") Token token = new37(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 38:
                        {
                            @SuppressWarnings("hiding") Token token = new38(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 39:
                        {
                            @SuppressWarnings("hiding") Token token = new39(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 40:
                        {
                            @SuppressWarnings("hiding") Token token = new40(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 41:
                        {
                            @SuppressWarnings("hiding") Token token = new41(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 42:
                        {
                            @SuppressWarnings("hiding") Token token = new42(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 43:
                        {
                            @SuppressWarnings("hiding") Token token = new43(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 44:
                        {
                            @SuppressWarnings("hiding") Token token = new44(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 45:
                        {
                            @SuppressWarnings("hiding") Token token = new45(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 46:
                        {
                            @SuppressWarnings("hiding") Token token = new46(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 47:
                        {
                            @SuppressWarnings("hiding") Token token = new47(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 48:
                        {
                            @SuppressWarnings("hiding") Token token = new48(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 49:
                        {
                            @SuppressWarnings("hiding") Token token = new49(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 50:
                        {
                            @SuppressWarnings("hiding") Token token = new50(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 51:
                        {
                            @SuppressWarnings("hiding") Token token = new51(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 52:
                        {
                            @SuppressWarnings("hiding") Token token = new52(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 53:
                        {
                            @SuppressWarnings("hiding") Token token = new53(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 54:
                        {
                            @SuppressWarnings("hiding") Token token = new54(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 55:
                        {
                            @SuppressWarnings("hiding") Token token = new55(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 56:
                        {
                            @SuppressWarnings("hiding") Token token = new56(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 57:
                        {
                            @SuppressWarnings("hiding") Token token = new57(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 58:
                        {
                            @SuppressWarnings("hiding") Token token = new58(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    }
                }
                else
                {
                    if(this.text.length() > 0)
                    {
                        throw new LexerException(
                            "[" + (start_line + 1) + "," + (start_pos + 1) + "]" +
                            " Unknown token: " + this.text);
                    }

                    @SuppressWarnings("hiding") EOF token = new EOF(
                        start_line + 1,
                        start_pos + 1);
                    return token;
                }
            }
        }
    }

    Token new0(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TWhite(text, line, pos); }
    Token new1(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TComma(line, pos); }
    Token new2(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TLbr(line, pos); }
    Token new3(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TRbr(line, pos); }
    Token new4(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TDot(line, pos); }
    Token new5(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TAbs(text, line, pos); }
    Token new6(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TAnd(text, line, pos); }
    Token new7(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TAs(text, line, pos); }
    Token new8(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TBetween(text, line, pos); }
    Token new9(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TBy(text, line, pos); }
    Token new10(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TConcat(text, line, pos); }
    Token new11(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TCount(text, line, pos); }
    Token new12(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TDistinct(text, line, pos); }
    Token new13(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TEmpty(text, line, pos); }
    Token new14(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TEscape(text, line, pos); }
    Token new15(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TExists(text, line, pos); }
    Token new16(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TFetch(text, line, pos); }
    Token new17(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TFrom(text, line, pos); }
    Token new18(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TGroup(text, line, pos); }
    Token new19(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new THaving(text, line, pos); }
    Token new20(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TIn(text, line, pos); }
    Token new21(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TInner(text, line, pos); }
    Token new22(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TIs(text, line, pos); }
    Token new23(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TTJoin(text, line, pos); }
    Token new24(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TLeft(text, line, pos); }
    Token new25(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TLength(text, line, pos); }
    Token new26(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TLike(text, line, pos); }
    Token new27(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TLocate(text, line, pos); }
    Token new28(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TLower(text, line, pos); }
    Token new29(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TMember(text, line, pos); }
    Token new30(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TMod(text, line, pos); }
    Token new31(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TNot(text, line, pos); }
    Token new32(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TNull(text, line, pos); }
    Token new33(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TOf(text, line, pos); }
    Token new34(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TOr(text, line, pos); }
    Token new35(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TObject(text, line, pos); }
    Token new36(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TOrder(text, line, pos); }
    Token new37(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TOuter(text, line, pos); }
    Token new38(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TSelect(text, line, pos); }
    Token new39(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TSize(text, line, pos); }
    Token new40(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TSqrt(text, line, pos); }
    Token new41(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TSubstring(text, line, pos); }
    Token new42(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TTrim(text, line, pos); }
    Token new43(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TUpper(text, line, pos); }
    Token new44(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TWhere(text, line, pos); }
    Token new45(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TBooleanLiteral(text, line, pos); }
    Token new46(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TIntegerLiteral(text, line, pos); }
    Token new47(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TFloatLiteral(text, line, pos); }
    Token new48(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TStringLiteral(text, line, pos); }
    Token new49(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TInputParameter(text, line, pos); }
    Token new50(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TAggregateFunc(text, line, pos); }
    Token new51(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TOrderbySpec(text, line, pos); }
    Token new52(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TAllAnySome(text, line, pos); }
    Token new53(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TComparisonOperator(text, line, pos); }
    Token new54(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TAddSub(text, line, pos); }
    Token new55(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TMulDiv(text, line, pos); }
    Token new56(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TFunctionsReturningDatetime(text, line, pos); }
    Token new57(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TTrimSpecification(text, line, pos); }
    Token new58(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TId(text, line, pos); }

    private int getChar() throws IOException
    {
        if(this.eof)
        {
            return -1;
        }

        int result = this.in.read();

        if(result == -1)
        {
            this.eof = true;
        }

        return result;
    }

    private void pushBack(int acceptLength) throws IOException
    {
        int length = this.text.length();
        for(int i = length - 1; i >= acceptLength; i--)
        {
            this.eof = false;

            this.in.unread(this.text.charAt(i));
        }
    }

    protected void unread(@SuppressWarnings("hiding") Token token) throws IOException
    {
        @SuppressWarnings("hiding") String text = token.getText();
        int length = text.length();

        for(int i = length - 1; i >= 0; i--)
        {
            this.eof = false;

            this.in.unread(text.charAt(i));
        }

        this.pos = token.getPos() - 1;
        this.line = token.getLine() - 1;
    }

    private String getText(int acceptLength)
    {
        StringBuffer s = new StringBuffer(acceptLength);
        for(int i = 0; i < acceptLength; i++)
        {
            s.append(this.text.charAt(i));
        }

        return s.toString();
    }

    private static int[][][][] gotoTable;
/*  {
        { // INITIAL
            {{32, 32, 1}, {34, 34, 2}, {39, 39, 3}, {40, 40, 4}, {41, 41, 5}, {42, 42, 6}, {43, 43, 7}, {44, 44, 8}, {45, 45, 9}, {46, 46, 10}, {47, 47, 11}, {48, 57, 12}, {58, 58, 13}, {60, 60, 14}, {61, 61, 15}, {62, 62, 16}, {63, 63, 17}, {65, 65, 18}, {66, 66, 19}, {67, 67, 20}, {68, 68, 21}, {69, 69, 22}, {70, 70, 23}, {71, 71, 24}, {72, 72, 25}, {73, 73, 26}, {74, 74, 27}, {75, 75, 28}, {76, 76, 29}, {77, 77, 30}, {78, 78, 31}, {79, 79, 32}, {80, 82, 28}, {83, 83, 33}, {84, 84, 34}, {85, 85, 35}, {86, 86, 28}, {87, 87, 36}, {88, 90, 28}, {92, 92, 37}, {97, 97, 38}, {98, 98, 39}, {99, 99, 40}, {100, 100, 41}, {101, 101, 42}, {102, 102, 43}, {103, 103, 44}, {104, 104, 45}, {105, 105, 46}, {106, 106, 47}, {107, 107, 48}, {108, 108, 49}, {109, 109, 50}, {110, 110, 51}, {111, 111, 52}, {112, 114, 48}, {115, 115, 53}, {116, 116, 54}, {117, 117, 55}, {118, 118, 48}, {119, 119, 56}, {120, 122, 48}, },
            {{32, 32, 1}, {92, 92, 37}, },
            {{0, 33, 57}, {34, 34, 58}, {35, 65535, 57}, },
            {{0, 38, 59}, {39, 39, 60}, {40, 65535, 59}, },
            {},
            {},
            {},
            {},
            {},
            {},
            {},
            {},
            {{46, 46, 61}, {48, 57, 12}, },
            {{46, 46, 62}, {48, 57, 63}, {65, 90, 64}, {95, 95, 65}, {97, 122, 66}, },
            {{61, 61, 67}, {62, 62, 68}, },
            {},
            {{61, 61, 69}, },
            {{48, 57, 70}, },
            {{46, 46, 71}, {48, 57, 72}, {65, 65, 73}, {66, 66, 74}, {67, 75, 73}, {76, 76, 75}, {77, 77, 73}, {78, 78, 76}, {79, 82, 73}, {83, 83, 77}, {84, 85, 73}, {86, 86, 78}, {87, 90, 73}, {95, 95, 79}, {97, 97, 80}, {98, 98, 81}, {99, 107, 80}, {108, 108, 82}, {109, 109, 80}, {110, 110, 83}, {111, 114, 80}, {115, 115, 84}, {116, 117, 80}, {118, 118, 85}, {119, 122, 80}, },
            {{46, 57, -20}, {65, 68, 73}, {69, 69, 86}, {70, 78, 73}, {79, 79, 87}, {80, 88, 73}, {89, 89, 88}, {90, 90, 73}, {95, 95, 79}, {97, 100, 80}, {101, 101, 89}, {102, 110, 80}, {111, 111, 90}, {112, 120, 80}, {121, 121, 91}, {122, 122, 80}, },
            {{46, 57, -20}, {65, 78, 73}, {79, 79, 92}, {80, 84, 73}, {85, 85, 93}, {86, 90, 73}, {95, 95, 79}, {97, 110, 80}, {111, 111, 94}, {112, 116, 80}, {117, 117, 95}, {118, 122, 80}, },
            {{46, 68, -21}, {69, 69, 96}, {70, 72, 73}, {73, 73, 97}, {74, 90, 73}, {95, 100, -21}, {101, 101, 98}, {102, 104, 80}, {105, 105, 99}, {106, 122, 80}, },
            {{46, 57, -20}, {65, 76, 73}, {77, 77, 100}, {78, 82, 73}, {83, 83, 101}, {84, 87, 73}, {88, 88, 102}, {89, 90, 73}, {95, 95, 79}, {97, 108, 80}, {109, 109, 103}, {110, 114, 80}, {115, 115, 104}, {116, 119, 80}, {120, 120, 105}, {121, 122, 80}, },
            {{46, 57, -20}, {65, 65, 106}, {66, 68, 73}, {69, 69, 107}, {70, 81, 73}, {82, 82, 108}, {83, 90, 73}, {95, 95, 79}, {97, 97, 109}, {98, 100, 80}, {101, 101, 110}, {102, 113, 80}, {114, 114, 111}, {115, 122, 80}, },
            {{46, 57, -20}, {65, 81, 73}, {82, 82, 112}, {83, 95, -25}, {97, 113, 80}, {114, 114, 113}, {115, 122, 80}, },
            {{46, 57, -20}, {65, 65, 114}, {66, 90, 73}, {95, 95, 79}, {97, 97, 115}, {98, 122, 80}, },
            {{46, 57, -20}, {65, 77, 73}, {78, 78, 116}, {79, 82, 73}, {83, 83, 117}, {84, 90, 73}, {95, 95, 79}, {97, 109, 80}, {110, 110, 118}, {111, 114, 80}, {115, 115, 119}, {116, 122, 80}, },
            {{46, 78, -22}, {79, 79, 120}, {80, 90, 73}, {95, 110, -22}, {111, 111, 121}, {112, 122, 80}, },
            {{46, 57, -20}, {65, 90, 73}, {95, 95, 79}, {97, 122, 80}, },
            {{46, 68, -21}, {69, 69, 122}, {70, 72, 73}, {73, 73, 123}, {74, 78, 73}, {79, 79, 124}, {80, 95, -29}, {97, 100, 80}, {101, 101, 125}, {102, 104, 80}, {105, 105, 126}, {106, 110, 80}, {111, 111, 127}, {112, 122, 80}, },
            {{46, 57, -20}, {65, 65, 128}, {66, 68, 73}, {69, 69, 129}, {70, 72, 73}, {73, 73, 130}, {74, 78, 73}, {79, 79, 131}, {80, 95, -29}, {97, 97, 132}, {98, 100, 80}, {101, 101, 133}, {102, 104, 80}, {105, 105, 134}, {106, 110, 80}, {111, 111, 135}, {112, 122, 80}, },
            {{46, 78, -22}, {79, 79, 136}, {80, 84, 73}, {85, 85, 137}, {86, 110, -22}, {111, 111, 138}, {112, 116, 80}, {117, 117, 139}, {118, 122, 80}, },
            {{46, 65, -20}, {66, 66, 140}, {67, 69, 73}, {70, 70, 141}, {71, 81, 73}, {82, 82, 142}, {83, 84, 73}, {85, 85, 143}, {86, 95, -22}, {97, 97, 80}, {98, 98, 144}, {99, 101, 80}, {102, 102, 145}, {103, 113, 80}, {114, 114, 146}, {115, 116, 80}, {117, 117, 147}, {118, 122, 80}, },
            {{46, 68, -21}, {69, 69, 148}, {70, 72, 73}, {73, 73, 149}, {74, 78, 73}, {79, 79, 150}, {80, 80, 73}, {81, 81, 151}, {82, 84, 73}, {85, 85, 152}, {86, 95, -22}, {97, 100, 80}, {101, 101, 153}, {102, 104, 80}, {105, 105, 154}, {106, 110, 80}, {111, 111, 155}, {112, 112, 80}, {113, 113, 156}, {114, 116, 80}, {117, 117, 157}, {118, 122, 80}, },
            {{46, 81, -26}, {82, 82, 158}, {83, 113, -26}, {114, 114, 159}, {115, 122, 80}, },
            {{46, 57, -20}, {65, 79, 73}, {80, 80, 160}, {81, 90, 73}, {95, 95, 79}, {97, 111, 80}, {112, 112, 161}, {113, 122, 80}, },
            {{46, 57, -20}, {65, 71, 73}, {72, 72, 162}, {73, 90, 73}, {95, 95, 79}, {97, 103, 80}, {104, 104, 163}, {105, 122, 80}, },
            {{110, 110, 164}, {114, 114, 165}, {116, 116, 166}, },
            {{46, 122, -20}, },
            {{46, 122, -21}, },
            {{46, 122, -22}, },
            {{46, 122, -23}, },
            {{46, 122, -24}, },
            {{46, 122, -25}, },
            {{46, 122, -26}, },
            {{46, 122, -27}, },
            {{46, 122, -28}, },
            {{46, 122, -29}, },
            {{46, 122, -30}, },
            {{46, 122, -31}, },
            {{46, 122, -32}, },
            {{46, 122, -33}, },
            {{46, 122, -34}, },
            {{46, 122, -35}, },
            {{46, 122, -36}, },
            {{46, 122, -37}, },
            {{46, 122, -38}, },
            {{0, 65535, -4}, },
            {},
            {{0, 65535, -5}, },
            {},
            {{48, 57, 167}, {101, 101, 168}, },
            {{46, 122, -15}, },
            {{46, 122, -15}, },
            {{46, 122, -15}, },
            {{46, 122, -15}, },
            {{46, 122, -15}, },
            {},
            {},
            {},
            {{48, 57, 70}, },
            {{46, 122, -30}, },
            {{46, 122, -30}, },
            {{46, 122, -30}, },
            {{46, 57, -20}, {65, 82, 73}, {83, 83, 169}, {84, 95, -28}, {97, 114, 80}, {115, 115, 170}, {116, 122, 80}, },
            {{46, 57, -20}, {65, 75, 73}, {76, 76, 171}, {77, 90, 73}, {95, 95, 79}, {97, 107, 80}, {108, 108, 172}, {109, 122, 80}, },
            {{46, 57, -20}, {65, 67, 73}, {68, 68, 173}, {69, 88, 73}, {89, 89, 174}, {90, 95, -21}, {97, 99, 80}, {100, 100, 175}, {101, 120, 80}, {121, 121, 176}, {122, 122, 80}, },
            {{46, 57, -20}, {65, 66, 73}, {67, 67, 177}, {68, 90, 73}, {95, 95, 79}, {97, 98, 80}, {99, 99, 178}, {100, 122, 80}, },
            {{46, 57, -20}, {65, 70, 73}, {71, 71, 179}, {72, 90, 73}, {95, 95, 79}, {97, 102, 80}, {103, 103, 180}, {104, 122, 80}, },
            {{46, 122, -30}, },
            {{46, 122, -30}, },
            {{46, 122, -76}, },
            {{46, 122, -77}, },
            {{46, 122, -78}, },
            {{46, 122, -79}, },
            {{46, 122, -80}, },
            {{46, 57, -20}, {65, 83, 73}, {84, 84, 181}, {85, 90, 73}, {95, 95, 79}, {97, 115, 80}, {116, 116, 182}, {117, 122, 80}, },
            {{46, 83, -88}, {84, 84, 183}, {85, 115, -88}, {116, 116, 184}, {117, 122, 80}, },
            {{46, 122, -30}, },
            {{46, 122, -88}, },
            {{46, 122, -89}, },
            {{46, 122, -30}, },
            {{46, 77, -28}, {78, 78, 185}, {79, 84, 73}, {85, 85, 186}, {86, 95, -22}, {97, 109, 80}, {110, 110, 187}, {111, 116, 80}, {117, 117, 188}, {118, 122, 80}, },
            {{46, 81, -26}, {82, 82, 189}, {83, 113, -26}, {114, 114, 190}, {115, 122, 80}, },
            {{46, 122, -94}, },
            {{46, 122, -95}, },
            {{46, 82, -76}, {83, 83, 191}, {84, 114, -76}, {115, 115, 192}, {116, 122, 80}, },
            {{46, 82, -76}, {83, 83, 193}, {84, 114, -76}, {115, 115, 194}, {116, 122, 80}, },
            {{46, 122, -98}, },
            {{46, 122, -99}, },
            {{46, 79, -37}, {80, 80, 195}, {81, 111, -37}, {112, 112, 196}, {113, 122, 80}, },
            {{46, 66, -79}, {67, 67, 197}, {68, 98, -79}, {99, 99, 198}, {100, 122, 80}, },
            {{46, 57, -20}, {65, 72, 73}, {73, 73, 199}, {74, 95, -23}, {97, 104, 80}, {105, 105, 200}, {106, 122, 80}, },
            {{46, 122, -102}, },
            {{46, 122, -103}, },
            {{46, 122, -104}, },
            {{46, 75, -77}, {76, 76, 201}, {77, 107, -77}, {108, 108, 202}, {109, 122, 80}, },
            {{46, 83, -88}, {84, 84, 203}, {85, 115, -88}, {116, 116, 204}, {117, 122, 80}, },
            {{46, 78, -22}, {79, 79, 205}, {80, 110, -29}, {111, 111, 206}, {112, 122, 80}, },
            {{46, 122, -108}, },
            {{46, 122, -109}, },
            {{46, 122, -110}, },
            {{46, 78, -22}, {79, 79, 207}, {80, 110, -29}, {111, 111, 208}, {112, 122, 80}, },
            {{46, 122, -114}, },
            {{46, 57, -20}, {65, 85, 73}, {86, 86, 209}, {87, 95, -20}, {97, 117, 80}, {118, 118, 210}, {119, 122, 80}, },
            {{46, 122, -116}, },
            {{46, 77, -28}, {78, 78, 211}, {79, 90, 73}, {95, 109, -28}, {110, 110, 212}, {111, 122, 80}, },
            {{46, 122, -30}, },
            {{46, 122, -118}, },
            {{46, 122, -30}, },
            {{46, 72, -104}, {73, 73, 213}, {74, 104, -104}, {105, 105, 214}, {106, 122, 80}, },
            {{46, 122, -122}, },
            {{46, 57, -20}, {65, 65, 215}, {66, 69, 73}, {70, 70, 216}, {71, 77, 73}, {78, 78, 217}, {79, 95, -118}, {97, 97, 218}, {98, 101, 80}, {102, 102, 219}, {103, 109, 80}, {110, 110, 220}, {111, 122, 80}, },
            {{46, 57, -20}, {65, 74, 73}, {75, 75, 221}, {76, 90, 73}, {95, 95, 79}, {97, 106, 80}, {107, 107, 222}, {108, 122, 80}, },
            {{46, 66, -79}, {67, 67, 223}, {68, 86, 73}, {87, 87, 224}, {88, 90, 73}, {95, 98, -79}, {99, 99, 225}, {100, 118, 80}, {119, 119, 226}, {120, 122, 80}, },
            {{46, 122, -124}, },
            {{46, 122, -125}, },
            {{46, 122, -126}, },
            {{46, 57, -20}, {65, 87, 73}, {88, 88, 227}, {89, 95, -24}, {97, 119, 80}, {120, 120, 228}, {121, 122, 80}, },
            {{46, 76, -24}, {77, 77, 229}, {78, 90, 73}, {95, 108, -24}, {109, 109, 230}, {110, 122, 80}, },
            {{46, 77, -28}, {78, 78, 231}, {79, 109, -118}, {110, 110, 232}, {111, 122, 80}, },
            {{46, 67, -78}, {68, 68, 233}, {69, 90, 73}, {95, 99, -78}, {100, 100, 234}, {101, 122, 80}, },
            {{46, 122, -130}, },
            {{46, 122, -131}, },
            {{46, 122, -132}, },
            {{46, 122, -133}, },
            {{46, 83, -88}, {84, 84, 235}, {85, 115, -88}, {116, 116, 236}, {117, 122, 80}, },
            {{46, 75, -77}, {76, 76, 237}, {77, 107, -77}, {108, 108, 238}, {109, 122, 80}, },
            {{46, 122, -138}, },
            {{46, 122, -139}, },
            {{46, 57, -20}, {65, 73, 73}, {74, 74, 239}, {75, 90, 73}, {95, 95, 79}, {97, 105, 80}, {106, 106, 240}, {107, 122, 80}, },
            {{46, 122, -30}, },
            {{46, 67, -78}, {68, 68, 241}, {69, 99, -133}, {100, 100, 242}, {101, 122, 80}, },
            {{46, 83, -88}, {84, 84, 243}, {85, 115, -88}, {116, 116, 244}, {117, 122, 80}, },
            {{46, 122, -142}, },
            {{46, 122, -30}, },
            {{46, 122, -144}, },
            {{46, 122, -145}, },
            {{46, 75, -77}, {76, 76, 245}, {77, 107, -77}, {108, 108, 246}, {109, 122, 80}, },
            {{46, 57, -20}, {65, 89, 73}, {90, 90, 247}, {95, 95, 79}, {97, 121, 80}, {122, 122, 248}, },
            {{46, 76, -24}, {77, 77, 249}, {78, 108, -131}, {109, 109, 250}, {110, 122, 80}, },
            {{46, 81, -26}, {82, 82, 251}, {83, 113, -26}, {114, 114, 252}, {115, 122, 80}, },
            {{46, 65, -20}, {66, 66, 253}, {67, 76, 73}, {77, 77, 254}, {78, 95, -131}, {97, 97, 80}, {98, 98, 255}, {99, 108, 80}, {109, 109, 256}, {110, 122, 80}, },
            {{46, 122, -150}, },
            {{46, 122, -151}, },
            {{46, 122, -152}, },
            {{46, 122, -153}, },
            {{46, 122, -154}, },
            {{46, 57, -20}, {65, 65, 257}, {66, 72, 73}, {73, 73, 258}, {74, 84, 73}, {85, 85, 259}, {86, 95, -22}, {97, 97, 260}, {98, 104, 80}, {105, 105, 261}, {106, 116, 80}, {117, 117, 262}, {118, 122, 80}, },
            {{46, 122, -160}, },
            {{46, 79, -37}, {80, 80, 263}, {81, 111, -37}, {112, 112, 264}, {113, 122, 80}, },
            {{46, 122, -162}, },
            {{46, 68, -21}, {69, 69, 265}, {70, 90, 73}, {95, 100, -21}, {101, 101, 266}, {102, 122, 80}, },
            {{46, 122, -164}, },
            {{32, 92, -3}, },
            {{32, 92, -3}, },
            {{32, 92, -3}, },
            {{48, 101, -63}, },
            {{43, 43, 267}, {45, 45, 268}, {48, 57, 269}, },
            {{46, 122, -30}, },
            {{46, 122, -30}, },
            {{46, 122, -30}, },
            {{46, 122, -30}, },
            {{46, 122, -30}, },
            {{46, 122, -30}, },
            {{46, 122, -30}, },
            {{46, 122, -30}, },
            {{46, 122, -30}, },
            {{46, 122, -30}, },
            {{46, 122, -30}, },
            {{46, 122, -30}, },
            {{46, 57, -20}, {65, 86, 73}, {87, 87, 270}, {88, 95, -126}, {97, 118, 80}, {119, 119, 271}, {120, 122, 80}, },
            {{46, 122, -183}, },
            {{46, 71, -38}, {72, 72, 272}, {73, 103, -38}, {104, 104, 273}, {105, 122, 80}, },
            {{46, 122, -185}, },
            {{46, 66, -79}, {67, 67, 274}, {68, 98, -79}, {99, 99, 275}, {100, 122, 80}, },
            {{46, 77, -28}, {78, 78, 276}, {79, 109, -118}, {110, 110, 277}, {111, 122, 80}, },
            {{46, 122, -187}, },
            {{46, 122, -188}, },
            {{46, 81, -26}, {82, 82, 278}, {83, 113, -26}, {114, 114, 279}, {115, 122, 80}, },
            {{46, 122, -191}, },
            {{46, 66, -79}, {67, 67, 280}, {68, 98, -79}, {99, 99, 281}, {100, 122, 80}, },
            {{46, 122, -193}, },
            {{46, 83, -88}, {84, 84, 282}, {85, 115, -88}, {116, 116, 283}, {117, 122, 80}, },
            {{46, 122, -195}, },
            {{46, 83, -88}, {84, 84, 284}, {85, 115, -88}, {116, 116, 285}, {117, 122, 80}, },
            {{46, 122, -197}, },
            {{46, 57, -20}, {65, 65, 286}, {66, 95, -27}, {97, 97, 287}, {98, 122, 80}, },
            {{46, 122, -199}, },
            {{46, 82, -76}, {83, 83, 288}, {84, 114, -76}, {115, 115, 289}, {116, 122, 80}, },
            {{46, 122, -201}, },
            {{46, 82, -76}, {83, 83, 290}, {84, 114, -76}, {115, 115, 291}, {116, 122, 80}, },
            {{46, 122, -203}, },
            {{46, 66, -79}, {67, 67, 292}, {68, 98, -79}, {99, 99, 293}, {100, 122, 80}, },
            {{46, 122, -205}, },
            {{46, 76, -24}, {77, 77, 294}, {78, 108, -131}, {109, 109, 295}, {110, 122, 80}, },
            {{46, 122, -207}, },
            {{46, 57, -20}, {65, 84, 73}, {85, 85, 296}, {86, 95, -22}, {97, 116, 80}, {117, 117, 297}, {118, 122, 80}, },
            {{46, 122, -209}, },
            {{46, 72, -104}, {73, 73, 298}, {74, 104, -104}, {105, 105, 299}, {106, 122, 80}, },
            {{46, 122, -211}, },
            {{46, 68, -21}, {69, 69, 300}, {70, 100, -164}, {101, 101, 301}, {102, 122, 80}, },
            {{46, 122, -213}, },
            {{46, 77, -28}, {78, 78, 302}, {79, 109, -118}, {110, 110, 303}, {111, 122, 80}, },
            {{46, 122, -215}, },
            {{46, 67, -78}, {68, 68, 304}, {69, 99, -133}, {100, 100, 305}, {101, 122, 80}, },
            {{46, 83, -88}, {84, 84, 306}, {85, 115, -88}, {116, 116, 307}, {117, 122, 80}, },
            {{46, 70, -80}, {71, 71, 308}, {72, 102, -80}, {103, 103, 309}, {104, 122, 80}, },
            {{46, 122, -217}, },
            {{46, 122, -218}, },
            {{46, 122, -219}, },
            {{46, 68, -21}, {69, 69, 310}, {70, 100, -164}, {101, 101, 311}, {102, 122, 80}, },
            {{46, 122, -223}, },
            {{46, 57, -20}, {65, 65, 312}, {66, 95, -27}, {97, 97, 313}, {98, 122, 80}, },
            {{46, 68, -21}, {69, 69, 314}, {70, 100, -164}, {101, 101, 315}, {102, 122, 80}, },
            {{46, 122, -225}, },
            {{46, 122, -226}, },
            {{46, 122, -30}, },
            {{46, 122, -30}, },
            {{46, 65, -20}, {66, 66, 316}, {67, 90, 73}, {95, 97, -20}, {98, 98, 317}, {99, 122, 80}, },
            {{46, 122, -231}, },
            {{46, 122, -30}, },
            {{46, 122, -30}, },
            {{46, 122, -30}, },
            {{46, 122, -30}, },
            {{46, 122, -30}, },
            {{46, 122, -30}, },
            {{46, 75, -77}, {76, 76, 318}, {77, 107, -77}, {108, 108, 319}, {109, 122, 80}, },
            {{46, 122, -239}, },
            {{46, 68, -21}, {69, 69, 320}, {70, 100, -164}, {101, 101, 321}, {102, 122, 80}, },
            {{46, 122, -241}, },
            {{46, 68, -21}, {69, 69, 322}, {70, 100, -164}, {101, 101, 323}, {102, 122, 80}, },
            {{46, 122, -243}, },
            {{46, 68, -21}, {69, 69, 324}, {70, 100, -164}, {101, 101, 325}, {102, 122, 80}, },
            {{46, 122, -245}, },
            {{46, 68, -21}, {69, 69, 326}, {70, 100, -164}, {101, 101, 327}, {102, 122, 80}, },
            {{46, 122, -247}, },
            {{46, 68, -21}, {69, 69, 328}, {70, 100, -164}, {101, 101, 329}, {102, 122, 80}, },
            {{46, 122, -249}, },
            {{46, 68, -21}, {69, 69, 330}, {70, 100, -164}, {101, 101, 331}, {102, 122, 80}, },
            {{46, 122, -251}, },
            {{46, 83, -88}, {84, 84, 332}, {85, 115, -88}, {116, 116, 333}, {117, 122, 80}, },
            {{46, 122, -253}, },
            {{46, 82, -76}, {83, 83, 334}, {84, 114, -76}, {115, 115, 335}, {116, 122, 80}, },
            {{46, 122, -30}, },
            {{46, 122, -255}, },
            {{46, 122, -30}, },
            {{46, 72, -104}, {73, 73, 336}, {74, 104, -104}, {105, 105, 337}, {106, 122, 80}, },
            {{46, 76, -24}, {77, 77, 338}, {78, 108, -131}, {109, 109, 339}, {110, 122, 80}, },
            {{46, 68, -21}, {69, 69, 340}, {70, 100, -164}, {101, 101, 341}, {102, 122, 80}, },
            {{46, 122, -259}, },
            {{46, 122, -260}, },
            {{46, 122, -261}, },
            {{46, 68, -21}, {69, 69, 342}, {70, 100, -164}, {101, 101, 343}, {102, 122, 80}, },
            {{46, 122, -265}, },
            {{46, 81, -26}, {82, 82, 344}, {83, 113, -26}, {114, 114, 345}, {115, 122, 80}, },
            {{46, 122, -267}, },
            {{48, 57, 269}, },
            {{48, 57, 269}, },
            {{48, 57, 269}, },
            {{46, 68, -21}, {69, 69, 346}, {70, 100, -164}, {101, 101, 347}, {102, 122, 80}, },
            {{46, 122, -272}, },
            {{46, 122, -30}, },
            {{46, 122, -30}, },
            {{46, 57, -20}, {65, 65, 348}, {66, 95, -27}, {97, 97, 349}, {98, 122, 80}, },
            {{46, 122, -276}, },
            {{46, 83, -88}, {84, 84, 350}, {85, 115, -88}, {116, 116, 351}, {117, 122, 80}, },
            {{46, 122, -278}, },
            {{46, 68, -21}, {69, 69, 352}, {70, 100, -164}, {101, 101, 353}, {102, 122, 80}, },
            {{46, 122, -280}, },
            {{46, 122, -30}, },
            {{46, 122, -30}, },
            {{46, 72, -104}, {73, 73, 354}, {74, 104, -104}, {105, 105, 355}, {106, 122, 80}, },
            {{46, 122, -284}, },
            {{46, 57, -20}, {65, 88, 73}, {89, 89, 356}, {90, 95, -21}, {97, 120, 80}, {121, 121, 357}, {122, 122, 80}, },
            {{46, 122, -286}, },
            {{46, 79, -37}, {80, 80, 358}, {81, 111, -37}, {112, 112, 359}, {113, 122, 80}, },
            {{46, 122, -288}, },
            {{46, 83, -88}, {84, 84, 360}, {85, 115, -88}, {116, 116, 361}, {117, 122, 80}, },
            {{46, 122, -290}, },
            {{46, 68, -21}, {69, 69, 362}, {70, 100, -164}, {101, 101, 363}, {102, 122, 80}, },
            {{46, 122, -292}, },
            {{46, 71, -38}, {72, 72, 364}, {73, 103, -38}, {104, 104, 365}, {105, 122, 80}, },
            {{46, 122, -294}, },
            {{46, 122, -30}, },
            {{46, 122, -30}, },
            {{46, 79, -37}, {80, 80, 366}, {81, 111, -37}, {112, 112, 367}, {113, 122, 80}, },
            {{46, 122, -298}, },
            {{46, 77, -28}, {78, 78, 368}, {79, 109, -118}, {110, 110, 369}, {111, 122, 80}, },
            {{46, 122, -300}, },
            {{46, 81, -26}, {82, 82, 370}, {83, 113, -26}, {114, 114, 371}, {115, 122, 80}, },
            {{46, 122, -302}, },
            {{46, 122, -30}, },
            {{46, 122, -30}, },
            {{46, 72, -104}, {73, 73, 372}, {74, 104, -104}, {105, 105, 373}, {106, 122, 80}, },
            {{46, 122, -306}, },
            {{46, 122, -30}, },
            {{46, 122, -30}, },
            {{46, 83, -88}, {84, 84, 374}, {85, 115, -88}, {116, 116, 375}, {117, 122, 80}, },
            {{46, 122, -310}, },
            {{46, 122, -30}, },
            {{46, 122, -30}, },
            {{46, 83, -88}, {84, 84, 376}, {85, 115, -88}, {116, 116, 377}, {117, 122, 80}, },
            {{46, 122, -314}, },
            {{46, 81, -26}, {82, 82, 378}, {83, 113, -26}, {114, 114, 379}, {115, 122, 80}, },
            {{46, 122, -316}, },
            {{46, 68, -21}, {69, 69, 380}, {70, 100, -164}, {101, 101, 381}, {102, 122, 80}, },
            {{46, 122, -318}, },
            {{46, 122, -30}, },
            {{46, 122, -30}, },
            {{46, 66, -79}, {67, 67, 382}, {68, 98, -79}, {99, 99, 383}, {100, 122, 80}, },
            {{46, 122, -322}, },
            {{46, 81, -26}, {82, 82, 384}, {83, 113, -26}, {114, 114, 385}, {115, 122, 80}, },
            {{46, 122, -324}, },
            {{46, 81, -26}, {82, 82, 386}, {83, 113, -26}, {114, 114, 387}, {115, 122, 80}, },
            {{46, 122, -326}, },
            {{46, 66, -79}, {67, 67, 388}, {68, 98, -79}, {99, 99, 389}, {100, 122, 80}, },
            {{46, 122, -328}, },
            {{46, 122, -30}, },
            {{46, 122, -30}, },
            {{46, 122, -30}, },
            {{46, 122, -30}, },
            {{46, 122, -30}, },
            {{46, 122, -30}, },
            {{46, 83, -88}, {84, 84, 390}, {85, 115, -88}, {116, 116, 391}, {117, 122, 80}, },
            {{46, 122, -336}, },
            {{46, 75, -77}, {76, 76, 392}, {77, 107, -77}, {108, 108, 393}, {109, 122, 80}, },
            {{46, 122, -338}, },
            {{46, 122, -30}, },
            {{46, 122, -30}, },
            {{46, 122, -30}, },
            {{46, 122, -30}, },
            {{46, 81, -26}, {82, 82, 394}, {83, 113, -26}, {114, 114, 395}, {115, 122, 80}, },
            {{46, 122, -344}, },
            {{46, 68, -21}, {69, 69, 396}, {70, 100, -164}, {101, 101, 397}, {102, 122, 80}, },
            {{46, 122, -346}, },
            {{46, 68, -21}, {69, 69, 398}, {70, 100, -164}, {101, 101, 399}, {102, 122, 80}, },
            {{46, 122, -348}, },
            {{46, 83, -88}, {84, 84, 400}, {85, 115, -88}, {116, 116, 401}, {117, 122, 80}, },
            {{46, 122, -350}, },
            {{46, 122, -30}, },
            {{46, 122, -30}, },
            {{46, 77, -28}, {78, 78, 402}, {79, 109, -118}, {110, 110, 403}, {111, 122, 80}, },
            {{46, 122, -354}, },
            {{46, 77, -28}, {78, 78, 404}, {79, 109, -118}, {110, 110, 405}, {111, 122, 80}, },
            {{46, 122, -356}, },
            {{46, 122, -30}, },
            {{46, 122, -30}, },
            {{46, 68, -21}, {69, 69, 406}, {70, 100, -164}, {101, 101, 407}, {102, 122, 80}, },
            {{46, 122, -360}, },
            {{46, 82, -76}, {83, 83, 408}, {84, 114, -76}, {115, 115, 409}, {116, 122, 80}, },
            {{46, 122, -362}, },
            {{46, 122, -30}, },
            {{46, 122, -30}, },
            {{46, 122, -30}, },
            {{46, 122, -30}, },
            {{46, 122, -30}, },
            {{46, 122, -30}, },
            {{46, 70, -80}, {71, 71, 410}, {72, 102, -80}, {103, 103, 411}, {104, 122, 80}, },
            {{46, 122, -370}, },
            {{46, 122, -30}, },
            {{46, 122, -30}, },
            {{46, 77, -28}, {78, 78, 412}, {79, 109, -118}, {110, 110, 413}, {111, 122, 80}, },
            {{46, 122, -374}, },
            {{46, 71, -38}, {72, 72, 414}, {73, 103, -38}, {104, 104, 415}, {105, 122, 80}, },
            {{46, 122, -376}, },
            {{46, 68, -21}, {69, 69, 416}, {70, 100, -164}, {101, 101, 417}, {102, 122, 80}, },
            {{46, 122, -378}, },
            {{46, 122, -30}, },
            {{46, 122, -30}, },
            {{46, 81, -26}, {82, 82, 418}, {83, 113, -26}, {114, 114, 419}, {115, 122, 80}, },
            {{46, 122, -382}, },
            {{46, 83, -88}, {84, 84, 420}, {85, 115, -88}, {116, 116, 421}, {117, 122, 80}, },
            {{46, 122, -384}, },
            {{46, 122, -30}, },
            {{46, 122, -30}, },
            {{46, 122, -30}, },
            {{46, 122, -30}, },
            {{46, 83, -88}, {84, 84, 422}, {85, 115, -88}, {116, 116, 423}, {117, 122, 80}, },
            {{46, 122, -390}, },
            {{46, 81, -26}, {82, 82, 424}, {83, 113, -26}, {114, 114, 425}, {115, 122, 80}, },
            {{46, 122, -392}, },
            {{46, 72, -104}, {73, 73, 426}, {74, 104, -104}, {105, 105, 427}, {106, 122, 80}, },
            {{46, 122, -394}, },
            {{46, 122, -30}, },
            {{46, 122, -30}, },
            {{46, 122, -30}, },
            {{46, 122, -30}, },
            {{46, 77, -28}, {78, 78, 428}, {79, 109, -118}, {110, 110, 429}, {111, 122, 80}, },
            {{46, 122, -400}, },
            {{46, 122, -30}, },
            {{46, 122, -30}, },
            {{46, 83, -88}, {84, 84, 430}, {85, 115, -88}, {116, 116, 431}, {117, 122, 80}, },
            {{46, 122, -404}, },
            {{46, 66, -79}, {67, 67, 432}, {68, 98, -79}, {99, 99, 433}, {100, 122, 80}, },
            {{46, 122, -406}, },
            {{46, 122, -30}, },
            {{46, 122, -30}, },
            {{46, 122, -30}, },
            {{46, 122, -30}, },
            {{46, 122, -30}, },
            {{46, 122, -30}, },
            {{46, 70, -80}, {71, 71, 434}, {72, 102, -80}, {103, 103, 435}, {104, 122, 80}, },
            {{46, 122, -414}, },
            {{46, 122, -30}, },
            {{46, 122, -30}, },
            {{46, 122, -30}, },
            {{46, 122, -30}, },
            {{46, 122, -30}, },
            {{46, 122, -30}, },
            {{46, 122, -30}, },
            {{46, 122, -30}, },
            {{46, 122, -30}, },
            {{46, 122, -30}, },
            {{46, 72, -104}, {73, 73, 436}, {74, 104, -104}, {105, 105, 437}, {106, 122, 80}, },
            {{46, 122, -426}, },
            {{46, 77, -28}, {78, 78, 438}, {79, 109, -118}, {110, 110, 439}, {111, 122, 80}, },
            {{46, 122, -428}, },
            {{46, 122, -30}, },
            {{46, 122, -30}, },
            {{46, 90, -30}, {95, 95, 440}, {97, 122, 80}, },
            {{46, 122, -432}, },
            {{46, 83, -88}, {84, 84, 441}, {85, 115, -88}, {116, 116, 442}, {117, 122, 80}, },
            {{46, 122, -434}, },
            {{46, 122, -30}, },
            {{46, 122, -30}, },
            {{46, 77, -28}, {78, 78, 443}, {79, 109, -118}, {110, 110, 444}, {111, 122, 80}, },
            {{46, 122, -438}, },
            {{46, 70, -80}, {71, 71, 445}, {72, 102, -80}, {103, 103, 446}, {104, 122, 80}, },
            {{46, 122, -440}, },
            {{46, 67, -78}, {68, 68, 447}, {69, 83, 73}, {84, 84, 448}, {85, 95, -88}, {97, 99, 80}, {100, 100, 449}, {101, 115, 80}, {116, 116, 450}, {117, 122, 80}, },
            {{46, 122, -30}, },
            {{46, 122, -30}, },
            {{46, 70, -80}, {71, 71, 451}, {72, 102, -80}, {103, 103, 452}, {104, 122, 80}, },
            {{46, 122, -445}, },
            {{46, 122, -30}, },
            {{46, 122, -30}, },
            {{46, 57, -20}, {65, 65, 453}, {66, 95, -27}, {97, 97, 454}, {98, 122, 80}, },
            {{46, 72, -104}, {73, 73, 455}, {74, 104, -104}, {105, 105, 456}, {106, 122, 80}, },
            {{46, 122, -449}, },
            {{46, 122, -450}, },
            {{46, 122, -30}, },
            {{46, 122, -30}, },
            {{46, 83, -88}, {84, 84, 457}, {85, 115, -88}, {116, 116, 458}, {117, 122, 80}, },
            {{46, 122, -455}, },
            {{46, 76, -24}, {77, 77, 459}, {78, 108, -131}, {109, 109, 460}, {110, 122, 80}, },
            {{46, 122, -457}, },
            {{46, 68, -21}, {69, 69, 461}, {70, 100, -164}, {101, 101, 462}, {102, 122, 80}, },
            {{46, 122, -459}, },
            {{46, 68, -21}, {69, 69, 463}, {70, 100, -164}, {101, 101, 464}, {102, 122, 80}, },
            {{46, 122, -461}, },
            {{46, 122, -30}, },
            {{46, 122, -30}, },
            {{46, 82, -76}, {83, 83, 465}, {84, 114, -76}, {115, 115, 466}, {116, 122, 80}, },
            {{46, 122, -465}, },
            {{46, 83, -88}, {84, 84, 467}, {85, 115, -88}, {116, 116, 468}, {117, 122, 80}, },
            {{46, 122, -467}, },
            {{46, 57, -20}, {65, 65, 469}, {66, 95, -27}, {97, 97, 470}, {98, 122, 80}, },
            {{46, 122, -469}, },
            {{46, 76, -24}, {77, 77, 471}, {78, 108, -131}, {109, 109, 472}, {110, 122, 80}, },
            {{46, 122, -471}, },
            {{46, 79, -37}, {80, 80, 473}, {81, 111, -37}, {112, 112, 474}, {113, 122, 80}, },
            {{46, 122, -473}, },
            {{46, 122, -30}, },
            {{46, 122, -30}, },
        }
    };*/

    private static int[][] accept;
/*  {
        // INITIAL
        {-1, 0, -1, -1, 2, 3, 55, 54, 1, 54, 4, 55, 46, -1, 53, 53, 53, -1, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, -1, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, -1, 48, -1, 48, 47, 49, 49, 49, 49, 49, 53, 53, 53, 49, 58, 58, 58, 58, 58, 58, 7, 58, 58, 58, 58, 58, 58, 7, 58, 58, 58, 9, 58, 58, 9, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 20, 22, 20, 22, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 33, 34, 58, 58, 33, 34, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 0, 0, 0, 47, -1, 5, 5, 52, 52, 6, 52, 6, 52, 51, 51, 50, 50, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 50, 50, 58, 58, 50, 50, 30, 30, 31, 31, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 50, 58, 50, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, -1, -1, 47, 58, 58, 57, 57, 58, 58, 58, 58, 58, 58, 51, 51, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 17, 17, 58, 58, 58, 58, 58, 58, 23, 23, 58, 58, 24, 24, 58, 58, 26, 26, 58, 58, 58, 58, 58, 58, 32, 32, 58, 58, 58, 58, 58, 58, 58, 58, 39, 39, 52, 52, 40, 40, 58, 58, 58, 58, 42, 42, 45, 45, 58, 58, 58, 58, 58, 58, 58, 58, 11, 11, 58, 58, 58, 58, 13, 13, 58, 58, 58, 58, 45, 45, 16, 16, 18, 18, 58, 58, 21, 21, 58, 58, 58, 58, 58, 58, 28, 28, 58, 58, 58, 58, 36, 36, 37, 37, 58, 58, 58, 58, 58, 58, 43, 43, 44, 44, 58, 58, 10, 10, 58, 58, 58, 58, 14, 14, 15, 15, 19, 19, 58, 58, 25, 25, 27, 27, 29, 29, 35, 35, 38, 38, 58, 58, 58, 58, 8, 8, 58, 58, 58, 58, 57, 57, 58, 58, 58, 58, 58, 12, 12, 58, 58, 57, 57, 58, 58, 58, 58, 41, 41, 58, 58, 58, 58, 58, 58, 58, 58, 56, 56, 56, 56, 58, 58, 58, 58, 58, 58, 58, 58, 56, 56, },

    };*/

    public static class State
    {
        public final static State INITIAL = new State(0);

        private int id;

        private State(@SuppressWarnings("hiding") int id)
        {
            this.id = id;
        }

        public int id()
        {
            return this.id;
        }
    }

    static 
    {
        try
        {
            DataInputStream s = new DataInputStream(
                new BufferedInputStream(
                Lexer.class.getResourceAsStream("lexer.dat")));

            // read gotoTable
            int length = s.readInt();
            gotoTable = new int[length][][][];
            for(int i = 0; i < gotoTable.length; i++)
            {
                length = s.readInt();
                gotoTable[i] = new int[length][][];
                for(int j = 0; j < gotoTable[i].length; j++)
                {
                    length = s.readInt();
                    gotoTable[i][j] = new int[length][3];
                    for(int k = 0; k < gotoTable[i][j].length; k++)
                    {
                        for(int l = 0; l < 3; l++)
                        {
                            gotoTable[i][j][k][l] = s.readInt();
                        }
                    }
                }
            }

            // read accept
            length = s.readInt();
            accept = new int[length][];
            for(int i = 0; i < accept.length; i++)
            {
                length = s.readInt();
                accept[i] = new int[length];
                for(int j = 0; j < accept[i].length; j++)
                {
                    accept[i][j] = s.readInt();
                }
            }

            s.close();
        }
        catch(Exception e)
        {
            throw new RuntimeException("The file \"lexer.dat\" is either missing or corrupted.");
        }
    }
}
