/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.xwiki.query;

import org.xwiki.component.annotation.Role;
import org.xwiki.stability.Unstable;

/**
 * Generic interface to build a {@link Query} from some data.
 * 
 * @version $Id: d06420dc5672f89cfacd0eab4bacf9e6de54f56e $
 * @param <T> the type of data used to build the query
 * @since 9.8RC1
 */
@Role
@Unstable
public interface QueryBuilder<T>
{
    /**
     * Builds a query from the specified data.
     * 
     * @param data the data used to build the query
     * @return the built query
     * @throws QueryException if building the query fails
     */
    Query build(T data) throws QueryException;
}
