/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.query.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.query.internal.AbstractWhereQueryFilter;

@Component
@Named(value="text")
@Singleton
public class TextQueryFilter
extends AbstractWhereQueryFilter {
    private static final Pattern COLUMN_SEPARATOR = Pattern.compile("\\s*,\\s*");

    @Override
    public String filterStatement(String statement, String language) {
        String constraint = this.getFilterableColumns(statement).stream().map(column -> "lower(str(" + column + ")) like lower(:text)").collect(Collectors.joining(" or "));
        if (constraint.isEmpty()) {
            return statement;
        }
        return this.insertWhereClause('(' + constraint + ')', statement, language);
    }

    @Override
    public List filterResults(List results) {
        return results;
    }

    @Override
    protected boolean isFilterable(String statement) {
        return true;
    }

    private List<String> getFilterableColumns(String statement) {
        ArrayList<String> columns = new ArrayList<String>();
        String selectClause = statement.substring("select ".length(), StringUtils.indexOfIgnoreCase((CharSequence)statement, (CharSequence)" from ")).trim();
        selectClause = StringUtils.removeStartIgnoreCase((String)selectClause, (String)"distinct ");
        String[] stringArray = COLUMN_SEPARATOR.split(selectClause);
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String column;
            String columnWithoutAlias = column = stringArray[i];
            int aliasPosition = column.lastIndexOf(" as ");
            if (aliasPosition > 0) {
                columnWithoutAlias = column.substring(0, aliasPosition).trim();
                String alias = column.substring(aliasPosition + 4).trim();
                if (alias.startsWith("unfilterable")) continue;
            }
            columns.add(columnWithoutAlias);
        }
        return columns;
    }
}

