/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.query.internal;

import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.query.Query;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryExecutorManager;
import org.xwiki.query.SecureQuery;
import org.xwiki.security.authorization.ContextualAuthorizationManager;
import org.xwiki.security.authorization.Right;

@Component(roles={QueryExecutorManager.class})
@Named(value="secure")
@Singleton
public class SecureQueryExecutorManager
implements QueryExecutorManager {
    @Inject
    private QueryExecutorManager defaultQueryExecutorManager;
    @Inject
    private ContextualAuthorizationManager authorization;

    @Override
    public <T> List<T> execute(Query query) throws QueryException {
        if (query instanceof SecureQuery) {
            SecureQuery secureQuery = (SecureQuery)query;
            secureQuery.checkCurrentAuthor(true);
        } else if (!this.authorization.hasAccess(Right.PROGRAM)) {
            throw new QueryException("Unsecure query require programming right", query, null);
        }
        return this.defaultQueryExecutorManager.execute(query);
    }

    @Override
    public Set<String> getLanguages() {
        return this.defaultQueryExecutorManager.getLanguages();
    }
}

