/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.query.xwql.internal;

import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.query.Query;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryExecutor;
import org.xwiki.query.QueryManager;
import org.xwiki.query.xwql.internal.QueryTranslator;

@Component
@Named(value="xwql")
@Singleton
public class XWQLQueryExecutor
implements QueryExecutor {
    @Inject
    @Named(value="hql")
    private QueryTranslator translator;
    @Inject
    private ComponentManager componentManager;

    public QueryManager getQueryManager() throws ComponentLookupException {
        return (QueryManager)this.componentManager.lookup(QueryManager.class);
    }

    public <T> List<T> execute(Query query) throws QueryException {
        try {
            Query nativeQuery = this.getQueryManager().createQuery(this.translator.translate(query.getStatement()), this.translator.getOutputLanguage());
            nativeQuery.setLimit(query.getLimit());
            nativeQuery.setOffset(query.getOffset());
            nativeQuery.setWiki(query.getWiki());
            for (Map.Entry e : query.getNamedParameters().entrySet()) {
                nativeQuery.bindValue((String)e.getKey(), e.getValue());
            }
            for (Map.Entry e : query.getPositionalParameters().entrySet()) {
                nativeQuery.bindValue(((Integer)e.getKey()).intValue(), e.getValue());
            }
            return nativeQuery.execute();
        }
        catch (Exception e) {
            if (e instanceof QueryException) {
                throw (QueryException)e;
            }
            throw new QueryException("Exception while translating [" + query.getStatement() + "] XWQL query to the [" + this.translator.getOutputLanguage() + "] language", query, (Throwable)e);
        }
    }

    public QueryTranslator getTranslator() {
        return this.translator;
    }
}

