/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.query.xwql.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.query.jpql.node.PPath;
import org.xwiki.query.jpql.node.PXObjectDecl;
import org.xwiki.query.jpql.node.Start;
import org.xwiki.query.xwql.internal.AliasGenerator;
import org.xwiki.query.xwql.internal.InvalidQueryException;

public class QueryContext {
    private Start tree;
    private Map<String, DocumentInfo> documents = new HashMap<String, DocumentInfo>();
    private Map<String, ObjectInfo> objects = new HashMap<String, ObjectInfo>();
    private AliasGenerator aliasGenerator = new AliasGenerator();
    private DocumentAccessBridge documentAccessBridge;
    private Map<PXObjectDecl, ObjectInfo> nodeToObject = new HashMap<PXObjectDecl, ObjectInfo>();
    String DocumentFromName = "Document";

    public QueryContext(Start tree, DocumentAccessBridge documentAccessBridge) {
        this.tree = tree;
        this.documentAccessBridge = documentAccessBridge;
    }

    public Start getTree() {
        return this.tree;
    }

    public AliasGenerator getAliasGenerator() {
        return this.aliasGenerator;
    }

    public ObjectInfo addObject(String docAlias, String className, String objAlias, PXObjectDecl node) {
        DocumentInfo di = this.getDocument(docAlias);
        if (di == null) {
            throw new InvalidQueryException("Can't find document alias [" + docAlias + "]");
        }
        ObjectInfo res = new ObjectInfo(docAlias, className, objAlias);
        if (objAlias != null) {
            this.objects.put(objAlias, res);
        } else if (di.unnamedObjects.get(className) == null) {
            di.unnamedObjects.put(className, res);
        }
        this.nodeToObject.put(node, res);
        return res;
    }

    public void addDocument(String alias) {
        if (this.documents.get(alias) != null && !"doc".equals(alias)) {
            throw new InvalidQueryException("Redeclaration of document [" + alias + "]");
        }
        this.documents.put(alias, new DocumentInfo());
    }

    public DocumentInfo getDocument(String alias) {
        return this.documents.get(alias);
    }

    public ObjectInfo getObject(String objAlias) {
        return this.objects.get(objAlias);
    }

    public ObjectInfo getObject(PXObjectDecl node) {
        return this.nodeToObject.get(node);
    }

    public Collection<ObjectInfo> getObjects() {
        ArrayList<ObjectInfo> res = new ArrayList<ObjectInfo>();
        res.addAll(this.objects.values());
        for (DocumentInfo di : this.documents.values()) {
            res.addAll(di.unnamedObjects.values());
        }
        return res;
    }

    public Set<String> getDocuments() {
        return this.documents.keySet();
    }

    public class PropertyInfo {
        public ObjectInfo object;
        public String name;
        public String alias;
        public List<PPath> locations = new ArrayList<PPath>();

        public PropertyInfo(String name, ObjectInfo object) {
            this.name = name;
            this.object = object;
        }

        public String getType() throws Exception {
            return QueryContext.this.documentAccessBridge.getPropertyType(this.object.className, this.name);
        }

        public boolean isCustomMapped() throws Exception {
            return QueryContext.this.documentAccessBridge.isPropertyCustomMapped(this.object.className, this.name);
        }

        public String getValueField() throws Exception {
            String type = this.getType();
            if (type.endsWith("DBStringListProperty")) {
                return "list";
            }
            if (type.endsWith("StringListProperty")) {
                return "textValue";
            }
            return "value";
        }
    }

    public class ObjectInfo {
        public String docAlias;
        public String className;
        public String alias;
        public String customMappingAlias;
        public Map<String, PropertyInfo> properties = new HashMap<String, PropertyInfo>();

        public ObjectInfo(String docAlias, String className, String objAlias) {
            this.className = className;
            this.docAlias = docAlias;
            this.alias = objAlias;
        }

        public PropertyInfo addProperty(String propname, PPath location) {
            PropertyInfo prop = this.properties.get(propname);
            if (prop == null) {
                prop = new PropertyInfo(propname, this);
                this.properties.put(propname, prop);
            }
            prop.locations.add(location);
            return prop;
        }

        public boolean isCustomMapped() throws Exception {
            for (PropertyInfo p : this.properties.values()) {
                if (!p.isCustomMapped()) continue;
                return true;
            }
            return false;
        }
    }

    public class DocumentInfo {
        public String alias;
        public Map<String, ObjectInfo> unnamedObjects = new HashMap<String, ObjectInfo>();
    }
}

