/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.ratings;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseProperty;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.context.Execution;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.ratings.ConfiguredProvider;
import org.xwiki.ratings.RatingsConfiguration;
import org.xwiki.ratings.RatingsManager;

@Component
@Singleton
public class ConfiguredRatingsManagerProvider
implements ConfiguredProvider<RatingsManager> {
    @Inject
    private Logger logger;
    @Inject
    private Execution execution;
    @Inject
    private ComponentManager componentManager;
    @Inject
    private RatingsConfiguration ratingsConfiguration;

    protected XWikiContext getXWikiContext() {
        return (XWikiContext)this.execution.getContext().getProperty("xwikicontext");
    }

    protected XWiki getXWiki() {
        return this.getXWikiContext().getWiki();
    }

    @Override
    public RatingsManager get(DocumentReference documentRef) {
        String defaultHint = "default";
        String ratingsHint = this.getXWiki().Param("xwiki.ratings.managerHint", defaultHint);
        try {
            XWikiDocument configurationDocument = this.ratingsConfiguration.getConfigurationDocument(documentRef);
            if (!configurationDocument.isNew() && configurationDocument.getXObject((EntityReference)RatingsManager.RATINGS_CONFIG_CLASSREFERENCE) != null) {
                BaseProperty prop = (BaseProperty)configurationDocument.getXObject((EntityReference)RatingsManager.RATINGS_CONFIG_CLASSREFERENCE).get("managerHint");
                String hint = prop == null ? null : (String)prop.getValue();
                ratingsHint = hint == null ? ratingsHint : hint;
            }
        }
        catch (Exception e) {
            this.logger.error("Cannot read ratings config", (Throwable)e);
        }
        try {
            return (RatingsManager)this.componentManager.getInstance(RatingsManager.class, ratingsHint);
        }
        catch (ComponentLookupException e) {
            this.logger.error("Error loading ratings manager component for hint " + ratingsHint, (Throwable)e);
            try {
                return (RatingsManager)this.componentManager.getInstance(RatingsManager.class, defaultHint);
            }
            catch (ComponentLookupException e1) {
                return null;
            }
        }
    }
}

