/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.ratings.internal;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.BaseProperty;
import com.xpn.xwiki.web.Utils;
import java.util.Date;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.xwiki.localization.ContextualLocalizationManager;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.ratings.Rating;
import org.xwiki.ratings.RatingsException;
import org.xwiki.ratings.RatingsManager;
import org.xwiki.ratings.internal.SeparatePageRatingsManager;

public class SeparatePageRating
implements Rating {
    private DocumentReference documentRef;
    private XWikiDocument document;
    private XWikiContext context;
    private SeparatePageRatingsManager ratingsManager;

    public SeparatePageRating(DocumentReference documentRef, DocumentReference author, int vote, XWikiContext context, SeparatePageRatingsManager ratingsManager) throws RatingsException {
        this(documentRef, author, new Date(), vote, context, ratingsManager);
    }

    public SeparatePageRating(DocumentReference documentRef, DocumentReference author, Date date, int vote, XWikiContext context, SeparatePageRatingsManager ratingsManager) throws RatingsException {
        this.context = context;
        this.ratingsManager = ratingsManager;
        this.documentRef = documentRef;
        this.document = this.addDocument(documentRef, author, date, vote);
    }

    public SeparatePageRating(DocumentReference documentRef, XWikiDocument doc, XWikiContext context, SeparatePageRatingsManager ratingsManager) throws RatingsException {
        this.context = context;
        this.ratingsManager = ratingsManager;
        this.documentRef = documentRef;
        this.document = doc;
    }

    @Override
    public String getRatingId() {
        return this.getDocument().getFullName();
    }

    @Override
    public String getGlobalRatingId() {
        return this.getRatingId();
    }

    @Override
    public BaseObject getAsObject() {
        return this.getDocument().getXObject((EntityReference)RatingsManager.RATINGS_CLASSREFERENCE);
    }

    private XWikiDocument getDocument() {
        if (this.document == null) {
            try {
                this.document = this.context.getWiki().getDocument(this.ratingsManager.getRatingDocumentReference(this.documentRef), this.context);
            }
            catch (XWikiException e) {
                return null;
            }
        }
        return this.document;
    }

    @Override
    public DocumentReference getAuthor() {
        String objectVal = this.getAsObject().getStringValue("author");
        return this.ratingsManager.userReferenceResolver.resolve((Object)objectVal, new Object[]{this.documentRef});
    }

    @Override
    public Date getDate() {
        return this.getAsObject().getDateValue("date");
    }

    @Override
    public void setAuthor(DocumentReference author) {
        this.getAsObject().setStringValue("author", (String)this.ratingsManager.entityReferenceSerializer.serialize((EntityReference)author, new Object[0]));
    }

    @Override
    public void setDate(Date date) {
        this.getAsObject().setDateValue("date", date);
    }

    @Override
    public int getVote() {
        return this.getAsObject().getIntValue("vote");
    }

    @Override
    public void setVote(int vote) {
        this.getAsObject().setIntValue("vote", vote);
    }

    @Override
    public Object get(String propertyName) {
        try {
            return ((BaseProperty)this.getAsObject().get(propertyName)).getValue();
        }
        catch (XWikiException e) {
            return null;
        }
    }

    @Override
    public String display(String propertyName, String mode) {
        return this.document.display(propertyName, mode, this.getAsObject(), this.context);
    }

    @Override
    public void save() throws RatingsException {
        DocumentReference superadmin = new DocumentReference("xwiki", "XWiki", "superadmin");
        try {
            if (this.document == null) {
                throw new RatingsException(1120, 1120005, "Cannot save invalid separate page rating, the rating document is null");
            }
            this.document.setCreatorReference(superadmin);
            this.document.setAuthorReference(superadmin);
            ContextualLocalizationManager localization = (ContextualLocalizationManager)Utils.getComponent(ContextualLocalizationManager.class);
            this.context.getWiki().saveDocument(this.getDocument(), localization.getTranslationPlain("rating.saveComment", new Object[0]), true, this.context);
        }
        catch (XWikiException e) {
            throw new RatingsException(e);
        }
    }

    @Override
    public boolean remove() throws RatingsException {
        try {
            XWikiDocument doc = this.getDocument();
            this.context.getWiki().deleteDocument(doc, this.context);
        }
        catch (XWikiException e) {
            throw new RatingsException(e);
        }
        return true;
    }

    private XWikiDocument addDocument(DocumentReference documentRef, DocumentReference author, Date date, int vote) throws RatingsException {
        try {
            DocumentReference pageRef = this.ratingsManager.getRatingDocumentReference(documentRef);
            String parentDocName = (String)this.ratingsManager.entityReferenceSerializer.serialize((EntityReference)documentRef, new Object[0]);
            XWiki xwiki = this.context.getWiki();
            XWikiDocument doc = xwiki.getDocument(pageRef, this.context);
            doc.setParent(parentDocName);
            doc.setHidden(Boolean.valueOf(true));
            BaseObject obj = doc.newXObject((EntityReference)RatingsManager.RATINGS_CLASSREFERENCE, this.context);
            obj.setStringValue("author", (String)this.ratingsManager.entityReferenceSerializer.serialize((EntityReference)author, new Object[0]));
            obj.setDateValue("date", date);
            obj.setIntValue("vote", vote);
            obj.setStringValue("parent", parentDocName);
            return doc;
        }
        catch (XWikiException e) {
            throw new RatingsException(e);
        }
    }

    @Override
    public String toString() {
        boolean shouldAddSpace = false;
        StringBuffer sb = new StringBuffer();
        if (this.getAuthor() != null) {
            sb.append("\nAuthor=").append(this.getAuthor());
            shouldAddSpace = true;
        }
        if (this.getDate() != null) {
            sb.append(shouldAddSpace ? " " : "");
            sb.append("\nDate=").append(this.getDate());
            shouldAddSpace = true;
        }
        if (this.getVote() != 0) {
            sb.append(shouldAddSpace ? " " : "");
            sb.append("\nVote=").append(this.getVote()).append("\n");
            shouldAddSpace = true;
        }
        return sb.toString();
    }

    @Override
    public DocumentReference getDocumentReference() {
        return this.documentRef;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SeparatePageRating that = (SeparatePageRating)o;
        return new EqualsBuilder().append((Object)this.documentRef, (Object)that.documentRef).append((Object)this.document, (Object)that.document).append((Object)this.context, (Object)that.context).append((Object)this.ratingsManager, (Object)that.ratingsManager).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.documentRef).append((Object)this.document).append((Object)this.context).append((Object)this.ratingsManager).toHashCode();
    }
}

