/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.ratings.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.model.reference.SpaceReference;
import org.xwiki.observation.event.Event;
import org.xwiki.ratings.Rating;
import org.xwiki.ratings.RatingsException;
import org.xwiki.ratings.UpdateRatingEvent;
import org.xwiki.ratings.UpdatingRatingEvent;
import org.xwiki.ratings.internal.AbstractRatingsManager;
import org.xwiki.ratings.internal.SeparatePageRating;

@Component
@Singleton
@Named(value="separate")
public class SeparatePageRatingsManager
extends AbstractRatingsManager {
    public static final String SEPARATERATINGS_CONFIG_PARAM_PREFIX = "xwiki.ratings.separatepage.";
    public static final String SEPARATERATINGS_CONFIG_FIELDNAME_SEPARATEPAGE_SPACE = "space";
    public static final String SEPARATERATINGS_CONFIG_FIELDNAME_SEPARATEPAGE_RATINGS_SPACE_PER_SPACE = "ratingsSpacePerSpace";
    @Inject
    private Logger logger;
    @Inject
    @Named(value="user/current")
    protected DocumentReferenceResolver<String> userReferenceResolver;
    @Inject
    @Named(value="compactwiki")
    protected EntityReferenceSerializer<String> entityReferenceSerializer;

    public String getRatingsSpaceName(DocumentReference documentRef) {
        String ratingsSpaceName = this.getXWiki().Param("xwiki.ratings.separatepagemanager.spacename", "");
        ratingsSpaceName = this.getXWiki().getXWikiPreference("ratings_separatepagemanager_spacename", ratingsSpaceName, this.getXWikiContext());
        return this.getRatingsConfiguration().getConfigurationParameter(documentRef, "storageSpace", ratingsSpaceName);
    }

    public boolean hasRatingsSpaceForeachSpace(DocumentReference documentRef) {
        String result = this.getXWiki().Param("xwiki.ratings.separatepagemanager.ratingsspaceforeachspace", "0");
        result = this.getXWiki().getXWikiPreference("ratings_separatepagemanager_ratingsspaceforeachspace", result, this.getXWikiContext());
        return this.getRatingsConfiguration().getConfigurationParameter(documentRef, "storageSeparateSpaces", result).equals("1");
    }

    protected void saveRating(Rating rating) throws RatingsException {
        try {
            rating.save();
        }
        catch (XWikiException e) {
            throw new RatingsException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Rating setRating(DocumentReference documentRef, DocumentReference author, int vote) throws RatingsException {
        int oldVote;
        Rating rating = this.getRating(documentRef, author);
        if (rating == null) {
            oldVote = 0;
            rating = new SeparatePageRating(documentRef, author, vote, this.getXWikiContext(), this);
        } else {
            oldVote = rating.getVote();
            rating.setVote(vote);
            rating.setDate(new Date());
        }
        this.observationManager.notify((Event)new UpdatingRatingEvent(documentRef, rating, oldVote), null);
        boolean updateFailed = true;
        try {
            rating.save();
            this.updateAverageRatings(documentRef, rating, oldVote);
            updateFailed = false;
        }
        finally {
            if (updateFailed) {
                this.observationManager.notify((Event)new UpdatingRatingEvent(documentRef, rating, oldVote), null);
            } else {
                this.observationManager.notify((Event)new UpdateRatingEvent(documentRef, rating, oldVote), null);
            }
        }
        return rating;
    }

    @Override
    public List<Rating> getRatings(DocumentReference documentRef, int start, int count, boolean asc) throws RatingsException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Calling separate page manager code for ratings");
        }
        String sql = ", BaseObject as obj, StringProperty as parentprop where doc.fullName=obj.name and obj.className=?1 and obj.id=parentprop.id.id and parentprop.id.name=?2 and parentprop.value=?3 and obj.name not in (select obj2.name from BaseObject as obj2, StringProperty as statusprop where obj2.className=?4 and obj2.id=statusprop.id.id and statusprop.id.name=?5 and (statusprop.value=?6 or statusprop.value= ?7) and obj.id=obj2.id) order by doc.date " + (asc ? "asc" : "desc");
        ArrayList<String> params = new ArrayList<String>(Arrays.asList(this.getRatingsClassName(), "parent", (String)this.entityReferenceSerializer.serialize((EntityReference)documentRef, new Object[0]), this.getRatingsClassName(), "status", "moderated", "refused"));
        ArrayList<Rating> ratings = new ArrayList<Rating>();
        try {
            List ratingPageReferenceList = this.getXWikiContext().getWiki().getStore().searchDocumentReferences(sql, count, start, params, this.getXWikiContext());
            for (DocumentReference ratingPageReference : ratingPageReferenceList) {
                ratings.add(this.getRatingFromDocument(documentRef, this.getXWiki().getDocument(ratingPageReference, this.getXWikiContext())));
            }
        }
        catch (XWikiException e) {
            throw new RatingsException(e);
        }
        return ratings;
    }

    @Override
    public Rating getRating(DocumentReference documentRef, int id) throws RatingsException {
        String sql = ", BaseObject as obj, StringProperty as parentprop where doc.fullName=obj.name and obj.className=?1 and obj.id=parentprop.id.id and parentprop.id.name=?2 and parentprop.value=?3 and obj.name not in (select obj2.name from BaseObject as obj2, StringProperty as statusprop where obj2.className=?4 and obj2.id=statusprop.id.id and statusprop.id.name=?5 and (statusprop.value=?6 or statusprop.value=?7) and obj.id=obj2.id) order by doc.date desc";
        ArrayList<String> params = new ArrayList<String>(Arrays.asList(this.getRatingsClassName(), "parent", (String)this.entityReferenceSerializer.serialize((EntityReference)documentRef, new Object[0]), this.getRatingsClassName(), "status", "moderated", "refused"));
        try {
            List ratingPageReferenceList = this.getXWikiContext().getWiki().getStore().searchDocumentReferences(sql, 1, id, params, this.getXWikiContext());
            if (CollectionUtils.isEmpty((Collection)ratingPageReferenceList)) {
                return null;
            }
            return new SeparatePageRatingsManager().getRatingFromDocument(documentRef, this.getXWiki().getDocument((DocumentReference)ratingPageReferenceList.get(0), this.getXWikiContext()));
        }
        catch (XWikiException e) {
            throw new RatingsException(e);
        }
    }

    @Override
    public Rating getRating(DocumentReference documentRef, DocumentReference author) throws RatingsException {
        try {
            for (Rating rating : this.getRatings(documentRef, 0, 0, false)) {
                if (!author.equals((Object)rating.getAuthor())) continue;
                return rating;
            }
        }
        catch (XWikiException e) {
            return null;
        }
        return null;
    }

    @Override
    public Rating getRating(String ratingId) throws RatingsException {
        try {
            int i1 = StringUtils.indexOf((CharSequence)ratingId, (int)46);
            if (i1 == -1) {
                throw new RatingsException(1120, 1120004, "Invalid rating ID, cannot parse rating id");
            }
            XWikiDocument doc = this.getXWiki().getDocument(ratingId, this.getXWikiContext());
            if (doc.isNew()) {
                throw new RatingsException(1120, 1120004, "Invalid rating ID, rating does not exist");
            }
            BaseObject object = doc.getObject(this.getRatingsClassName());
            if (object == null) {
                throw new RatingsException(1120, 1120004, "Invalid rating ID, rating does not exist");
            }
            String parentDocName = object.getStringValue("parent");
            XWikiDocument parentDoc = this.getXWikiContext().getWiki().getDocument(parentDocName, this.getXWikiContext());
            return new SeparatePageRating(parentDoc.getDocumentReference(), doc, this.getXWikiContext(), this);
        }
        catch (XWikiException e) {
            throw new RatingsException(e);
        }
    }

    public Rating getRatingFromDocument(DocumentReference documentRef, XWikiDocument doc) throws RatingsException {
        return new SeparatePageRating(documentRef, doc, this.getXWikiContext(), this);
    }

    public DocumentReference getRatingDocumentReference(DocumentReference ratedDocumentReference) {
        XWikiContext context = this.getXWikiContext();
        String ratingsSpace = this.getRatingsSpaceName(ratedDocumentReference);
        String pageSuffix = "R";
        boolean hasRatingsSpaceForeachSpace = this.hasRatingsSpaceForeachSpace(ratedDocumentReference);
        SpaceReference spaceReference = ratedDocumentReference.getLastSpaceReference();
        spaceReference.replaceParent((EntityReference)spaceReference.getWikiReference(), (EntityReference)context.getWikiReference());
        if (hasRatingsSpaceForeachSpace) {
            spaceReference = new SpaceReference(spaceReference.getName() + ratingsSpace, spaceReference.getParent());
            return this.getUniquePageName(spaceReference, ratedDocumentReference.getName(), pageSuffix);
        }
        if (ratingsSpace == null) {
            return this.getUniquePageName(spaceReference, ratedDocumentReference.getName() + pageSuffix, "");
        }
        SpaceReference ratingSpaceReference = new SpaceReference(context.getWikiId(), new String[]{ratingsSpace});
        return this.getUniquePageName(ratingSpaceReference, ratedDocumentReference.getLastSpaceReference().getName() + "_" + ratedDocumentReference.getName(), pageSuffix);
    }

    private DocumentReference getUniquePageName(SpaceReference spaceReference, String name, String postfix) {
        XWikiContext context = this.getXWikiContext();
        String originalPageName = context.getWiki().clearName(name, context);
        DocumentReference documentReference = new DocumentReference(originalPageName, spaceReference);
        int i = 1;
        if (context.getWiki().exists(documentReference, context)) {
            do {
                String pageName = originalPageName + postfix + i;
                documentReference = new DocumentReference(pageName, spaceReference);
                ++i;
            } while (context.getWiki().exists(documentReference, context));
        }
        return documentReference;
    }
}

