/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.ratings.script;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.api.Document;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.ratings.AverageRatingApi;
import org.xwiki.ratings.ConfiguredProvider;
import org.xwiki.ratings.Rating;
import org.xwiki.ratings.RatingsConfiguration;
import org.xwiki.ratings.RatingsManager;
import org.xwiki.ratings.script.RatingApi;
import org.xwiki.script.service.ScriptService;

@Component
@Singleton
@Named(value="ratings")
public class RatingsScriptService
implements ScriptService {
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    private ConfiguredProvider<RatingsManager> ratingsManagerProvider;
    @Inject
    @Named(value="current")
    private DocumentReferenceResolver<String> documentReferenceResolver;
    @Inject
    @Named(value="current")
    private DocumentReferenceResolver<EntityReference> referenceDocumentReferenceResolver;
    @Inject
    @Named(value="user/current")
    private DocumentReferenceResolver<String> userReferenceResolver;
    @Inject
    private RatingsConfiguration ratingsConfiguration;

    private XWikiContext getXWikiContext() {
        return (XWikiContext)this.xcontextProvider.get();
    }

    private void setError(Throwable e) {
        this.getXWikiContext().put((Object)"exception", (Object)e);
    }

    private DocumentReference getGlobalConfig() {
        return this.referenceDocumentReferenceResolver.resolve((Object)RatingsManager.RATINGS_CONFIG_GLOBAL_REFERENCE, new Object[0]);
    }

    private static List<RatingApi> wrapRatings(List<Rating> ratings) {
        if (ratings == null) {
            return null;
        }
        ArrayList<RatingApi> ratingsResult = new ArrayList<RatingApi>();
        for (Rating rating : ratings) {
            ratingsResult.add(new RatingApi(rating));
        }
        return ratingsResult;
    }

    @Deprecated
    public RatingApi setRating(Document doc, String author, int vote) {
        DocumentReference documentRef = doc.getDocumentReference();
        DocumentReference authorRef = this.userReferenceResolver.resolve((Object)author, new Object[0]);
        return this.setRating(documentRef, authorRef, vote);
    }

    public RatingApi setRating(DocumentReference document, DocumentReference author, int vote) {
        this.setError(null);
        try {
            return new RatingApi(this.ratingsManagerProvider.get(document).setRating(document, author, vote));
        }
        catch (Throwable e) {
            this.setError(e);
            return null;
        }
    }

    @Deprecated
    public RatingApi getRating(Document doc, String author) {
        DocumentReference documentRef = doc.getDocumentReference();
        DocumentReference authorRef = this.userReferenceResolver.resolve((Object)author, new Object[0]);
        return this.getRating(documentRef, authorRef);
    }

    public RatingApi getRating(DocumentReference document, DocumentReference author) {
        this.setError(null);
        try {
            Rating rating = this.ratingsManagerProvider.get(document).getRating(document, author);
            if (rating == null) {
                return null;
            }
            return new RatingApi(rating);
        }
        catch (Throwable e) {
            this.setError(e);
            return null;
        }
    }

    @Deprecated
    public List<RatingApi> getRatings(Document doc, int start, int count) {
        return this.getRatings(doc.getDocumentReference(), start, count);
    }

    public List<RatingApi> getRatings(DocumentReference document, int start, int count) {
        return this.getRatings(document, start, count, true);
    }

    @Deprecated
    public List<RatingApi> getRatings(Document doc, int start, int count, boolean asc) {
        return this.getRatings(doc.getDocumentReference(), start, count, asc);
    }

    public List<RatingApi> getRatings(DocumentReference document, int start, int count, boolean asc) {
        this.setError(null);
        try {
            return RatingsScriptService.wrapRatings(this.ratingsManagerProvider.get(document).getRatings(document, start, count, asc));
        }
        catch (Exception e) {
            this.setError(e);
            return null;
        }
    }

    @Deprecated
    public AverageRatingApi getAverageRating(Document doc, String method) {
        return this.getAverageRating(doc.getDocumentReference(), method);
    }

    public AverageRatingApi getAverageRating(DocumentReference document, String method) {
        this.setError(null);
        try {
            return new AverageRatingApi(this.ratingsManagerProvider.get(document).getAverageRating(document, method));
        }
        catch (Throwable e) {
            this.setError(e);
            return null;
        }
    }

    @Deprecated
    public AverageRatingApi getAverageRating(Document doc) {
        return this.getAverageRating(doc.getDocumentReference());
    }

    public AverageRatingApi getAverageRating(DocumentReference document) {
        this.setError(null);
        try {
            return new AverageRatingApi(this.ratingsManagerProvider.get(document).getAverageRating(document));
        }
        catch (Throwable e) {
            this.setError(e);
            return null;
        }
    }

    public AverageRatingApi getAverageRating(String fromsql, String wheresql, String method) {
        this.setError(null);
        try {
            return new AverageRatingApi(this.ratingsManagerProvider.get(this.getGlobalConfig()).getAverageRatingFromQuery(fromsql, wheresql, method));
        }
        catch (Throwable e) {
            this.setError(e);
            return null;
        }
    }

    public AverageRatingApi getAverageRating(String fromsql, String wheresql) {
        this.setError(null);
        try {
            return new AverageRatingApi(this.ratingsManagerProvider.get(this.getGlobalConfig()).getAverageRatingFromQuery(fromsql, wheresql));
        }
        catch (Throwable e) {
            this.setError(e);
            return null;
        }
    }

    public AverageRatingApi getUserReputation(String username) {
        DocumentReference userRef = this.userReferenceResolver.resolve((Object)username, new Object[0]);
        return this.getUserReputation(userRef);
    }

    public AverageRatingApi getUserReputation(DocumentReference username) {
        this.setError(null);
        try {
            return new AverageRatingApi(this.ratingsManagerProvider.get(this.getGlobalConfig()).getUserReputation(username));
        }
        catch (Throwable e) {
            this.setError(e);
            return null;
        }
    }

    public Document getConfigurationDocument(DocumentReference documentReference) {
        return this.ratingsConfiguration.getConfigurationDocument(documentReference).newDocument(this.getXWikiContext());
    }
}

