/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.async.internal.block;

import javax.inject.Inject;
import javax.inject.Named;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.rendering.async.internal.block.BlockAsyncRenderer;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.internal.transformation.MutableRenderingContext;
import org.xwiki.rendering.transformation.RenderingContext;
import org.xwiki.rendering.transformation.Transformation;
import org.xwiki.rendering.transformation.TransformationContext;
import org.xwiki.rendering.transformation.TransformationException;
import org.xwiki.rendering.transformation.TransformationManager;

@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public abstract class AbstractBlockAsyncRenderer
implements BlockAsyncRenderer {
    @Inject
    protected TransformationManager transformationManager;
    @Inject
    @Named(value="macro")
    protected Transformation macroTransformation;
    @Inject
    protected RenderingContext renderingContext;

    protected void transform(Block block, TransformationContext transformationContext) throws TransformationException {
        if (this.isAsyncAllowed() || this.isCacheAllowed()) {
            this.transformationManager.performTransformations(block, transformationContext);
        } else {
            ((MutableRenderingContext)this.renderingContext).transformInContext(this.macroTransformation, transformationContext, block);
        }
    }
}

