/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.async.internal.block;

import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.descriptor.ComponentRole;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.rendering.RenderingException;
import org.xwiki.rendering.async.AsyncContext;
import org.xwiki.rendering.async.internal.block.AbstractBlockAsyncRenderer;
import org.xwiki.rendering.async.internal.block.BlockAsyncRendererConfiguration;
import org.xwiki.rendering.async.internal.block.BlockAsyncRendererResult;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.MetaDataBlock;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.renderer.BlockRenderer;
import org.xwiki.rendering.renderer.printer.DefaultWikiPrinter;
import org.xwiki.rendering.renderer.printer.WikiPrinter;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.transformation.TransformationContext;

@Component(roles={DefaultBlockAsyncRenderer.class})
public class DefaultBlockAsyncRenderer
extends AbstractBlockAsyncRenderer {
    @Inject
    @Named(value="context")
    private Provider<ComponentManager> componentManager;
    @Inject
    private AsyncContext asyncContext;
    private BlockAsyncRendererConfiguration configuration;

    public void initialize(BlockAsyncRendererConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public List<String> getId() {
        return this.configuration.getId();
    }

    @Override
    public boolean isAsyncAllowed() {
        return this.configuration.isAsyncAllowed();
    }

    @Override
    public boolean isCacheAllowed() {
        return this.configuration.isCacheAllowed();
    }

    @Override
    public boolean isInline() {
        return this.configuration.isInline();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public BlockAsyncRendererResult render(boolean async, boolean cached) throws RenderingException {
        void var4_10;
        for (EntityReference entityReference : this.configuration.getReferences()) {
            this.asyncContext.useEntity(entityReference);
        }
        for (ComponentRole componentRole : this.configuration.getRoles()) {
            this.asyncContext.useComponent(componentRole.getRoleType(), componentRole.getRoleHint());
        }
        Block block = this.configuration.getBlock();
        if (block instanceof XDOM) {
            XDOM xDOM = (XDOM)block;
        } else {
            Block rootBlock = block.getRoot();
            if (rootBlock instanceof XDOM) {
                XDOM xDOM = (XDOM)rootBlock;
            } else {
                XDOM xDOM = new XDOM(Collections.singletonList(rootBlock));
            }
        }
        Block resultBlock = this.tranform((XDOM)var4_10, block);
        String resultString = null;
        if (async || cached) {
            BlockRenderer renderer;
            Syntax targetSyntax = this.configuration.getTargetSyntax();
            try {
                renderer = (BlockRenderer)((ComponentManager)this.componentManager.get()).getInstance(BlockRenderer.class, targetSyntax.toIdString());
            }
            catch (ComponentLookupException e) {
                throw new RenderingException("Failed to lookup renderer for syntax [" + targetSyntax + "]", (Throwable)e);
            }
            DefaultWikiPrinter printer = new DefaultWikiPrinter();
            renderer.render(resultBlock, (WikiPrinter)printer);
            resultString = printer.toString();
        }
        return new BlockAsyncRendererResult(resultString, resultBlock);
    }

    private Block tranform(XDOM xdom, Block block) throws RenderingException {
        TransformationContext transformationContext = new TransformationContext(xdom, this.configuration.getDefaultSyntax(), false);
        transformationContext.setTargetSyntax(this.configuration.getTargetSyntax());
        transformationContext.setId(this.configuration.getTransformationId());
        this.transform(block, transformationContext);
        if (block instanceof XDOM) {
            return new MetaDataBlock(block.getChildren(), ((XDOM)block).getMetaData());
        }
        return block;
    }
}

