/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.async.internal;

import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.xwiki.component.descriptor.ComponentRole;
import org.xwiki.job.AbstractJobStatus;
import org.xwiki.job.Request;
import org.xwiki.job.annotation.Serializable;
import org.xwiki.job.event.status.JobStatus;
import org.xwiki.logging.LoggerManager;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.observation.ObservationManager;
import org.xwiki.rendering.async.internal.AsyncRendererJobRequest;
import org.xwiki.rendering.async.internal.AsyncRendererResult;
import org.xwiki.rendering.async.internal.DefaultAsyncContext;

@Serializable(value=false)
public class AsyncRendererJobStatus
extends AbstractJobStatus<AsyncRendererJobRequest> {
    public static final String JOBTYPE = "asyncrenderer";
    private AsyncRendererResult result;
    private Set<EntityReference> references;
    private Set<Type> roleTypes;
    private Set<ComponentRole<?>> roles;
    private Set<DefaultAsyncContext.RightEntry> rights;
    private Map<String, Collection<Object>> uses;
    private boolean async;
    private Set<String> clients = ConcurrentHashMap.newKeySet();

    public AsyncRendererJobStatus(AsyncRendererJobRequest request, ObservationManager observationManager, LoggerManager loggerManager) {
        super(JOBTYPE, (Request)request, null, observationManager, loggerManager);
        this.setIsolated(false);
        this.async = true;
    }

    public AsyncRendererJobStatus(AsyncRendererJobRequest request, AsyncRendererResult result) {
        super(JOBTYPE, (Request)request, null, null, null);
        this.async = false;
        this.setResult(result);
        this.setState(JobStatus.State.FINISHED);
        this.setEndDate(new Date());
    }

    AsyncRendererJobStatus(AsyncRendererJobRequest request, AsyncRendererResult result, Set<EntityReference> references, Set<Type> roleTypes, Set<ComponentRole<?>> roles, Set<DefaultAsyncContext.RightEntry> rights, Map<String, Collection<Object>> uses) {
        super(JOBTYPE, (Request)request, null, null, null);
        this.async = false;
        this.setResult(result);
        this.setReferences(references);
        this.setRoleTypes(roleTypes);
        this.setRoles(roles);
        this.setRights(rights);
        this.setUses(uses);
        this.setState(JobStatus.State.FINISHED);
        this.setEndDate(new Date());
    }

    public boolean isAsync() {
        return this.async;
    }

    public AsyncRendererResult getResult() {
        return this.result;
    }

    void setResult(AsyncRendererResult result) {
        this.result = result;
    }

    public Set<EntityReference> getReferences() {
        return this.references != null ? this.references : Collections.emptySet();
    }

    void setReferences(Set<EntityReference> references) {
        if (references != null) {
            this.references = Collections.unmodifiableSet(references);
        }
    }

    public Set<Type> getRoleTypes() {
        return this.roleTypes != null ? this.roleTypes : Collections.emptySet();
    }

    void setRoleTypes(Set<Type> roleTypes) {
        this.roleTypes = roleTypes;
    }

    public Set<ComponentRole<?>> getRoles() {
        return this.roles != null ? this.roles : Collections.emptySet();
    }

    void setRoles(Set<ComponentRole<?>> roles) {
        if (roles != null) {
            this.roles = Collections.unmodifiableSet(roles);
        }
    }

    public Set<DefaultAsyncContext.RightEntry> getRights() {
        return this.rights != null ? this.rights : Collections.emptySet();
    }

    void setRights(Set<DefaultAsyncContext.RightEntry> rights) {
        if (rights != null) {
            this.rights = Collections.unmodifiableSet(rights);
        }
    }

    public Map<String, Collection<Object>> getUses() {
        return this.uses;
    }

    public void setUses(Map<String, Collection<Object>> uses) {
        this.uses = uses;
    }

    public void addClient(String client) {
        this.clients.add(client);
    }

    public Set<String> getClients() {
        return this.clients;
    }

    void dispose() {
        ((AsyncRendererJobRequest)this.getRequest()).setContext(null);
        ((AsyncRendererJobRequest)this.getRequest()).setRenderer(null);
    }
}

