/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.async.internal.block;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.rendering.RenderingException;
import org.xwiki.rendering.async.internal.block.BlockAsyncRenderer;
import org.xwiki.rendering.async.internal.block.BlockAsyncRendererResult;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.CompositeBlock;
import org.xwiki.rendering.block.ParagraphBlock;
import org.xwiki.rendering.internal.transformation.MutableRenderingContext;
import org.xwiki.rendering.renderer.BlockRenderer;
import org.xwiki.rendering.renderer.printer.DefaultWikiPrinter;
import org.xwiki.rendering.renderer.printer.WikiPrinter;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.transformation.RenderingContext;
import org.xwiki.rendering.transformation.Transformation;
import org.xwiki.rendering.transformation.TransformationContext;
import org.xwiki.rendering.transformation.TransformationException;
import org.xwiki.rendering.transformation.TransformationManager;

@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public abstract class AbstractBlockAsyncRenderer
implements BlockAsyncRenderer {
    @Inject
    @Named(value="context")
    protected Provider<ComponentManager> componentManagerProvider;
    @Inject
    protected TransformationManager transformationManager;
    @Inject
    @Named(value="macro")
    protected Transformation macroTransformation;
    @Inject
    protected RenderingContext renderingContext;

    protected void transform(Block block, TransformationContext transformationContext) throws TransformationException {
        if (this.isAsyncAllowed() || this.isCacheAllowed()) {
            this.transformationManager.performTransformations(block, transformationContext);
        } else {
            ((MutableRenderingContext)this.renderingContext).transformInContext(this.macroTransformation, transformationContext, block);
        }
    }

    protected Block removeTopLevelParagraph(Block block) {
        List blocks = block.getChildren();
        if (block.getChildren().size() == 1 && block.getChildren().get(0) instanceof ParagraphBlock) {
            Block paragraphBlock = (Block)blocks.remove(0);
            blocks.addAll(0, paragraphBlock.getChildren());
            return new CompositeBlock(blocks);
        }
        return block;
    }

    protected String render(Block block) throws RenderingException {
        BlockRenderer renderer;
        try {
            Syntax targetSyntax = this.getTargetSyntax();
            if (targetSyntax == null) {
                targetSyntax = this.renderingContext.getTargetSyntax();
            }
            renderer = (BlockRenderer)((ComponentManager)this.componentManagerProvider.get()).getInstance(BlockRenderer.class, targetSyntax.toIdString());
        }
        catch (ComponentLookupException e) {
            throw new RenderingException("Failed to lookup renderer for syntax [" + this.getTargetSyntax() + "]", (Throwable)e);
        }
        DefaultWikiPrinter printer = new DefaultWikiPrinter();
        renderer.render(block, (WikiPrinter)printer);
        return printer.toString();
    }

    protected List<String> createId(Object ... values) {
        ArrayList<String> id = new ArrayList<String>(values.length);
        for (Object value : values) {
            if (value == null) {
                id.add("");
                continue;
            }
            id.add(value.toString());
        }
        return id;
    }

    @Override
    public BlockAsyncRendererResult render(boolean async, boolean cached) throws RenderingException {
        Block block = this.execute(async, cached);
        String resultString = null;
        if (this.isRendered(async, cached)) {
            resultString = this.render(block);
        }
        return new BlockAsyncRendererResult(resultString, block);
    }

    protected boolean isRendered(boolean async, boolean cached) {
        return async;
    }

    protected Block execute(boolean async, boolean cached) throws RenderingException {
        return null;
    }
}

