/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.async.internal;

import javax.inject.Inject;
import javax.inject.Named;
import org.xwiki.component.annotation.Component;
import org.xwiki.job.AbstractJob;
import org.xwiki.job.Request;
import org.xwiki.rendering.async.AsyncContext;
import org.xwiki.rendering.async.internal.AsyncRenderer;
import org.xwiki.rendering.async.internal.AsyncRendererCache;
import org.xwiki.rendering.async.internal.AsyncRendererJobRequest;
import org.xwiki.rendering.async.internal.AsyncRendererJobStatus;
import org.xwiki.rendering.async.internal.AsyncRendererResult;
import org.xwiki.rendering.async.internal.DefaultAsyncContext;
import org.xwiki.template.TemplateManager;

@Component
@Named(value="asyncrenderer")
public class AsyncRendererJob
extends AbstractJob<AsyncRendererJobRequest, AsyncRendererJobStatus> {
    @Inject
    private AsyncRendererCache cache;
    @Inject
    private AsyncContext asyncContext;
    @Inject
    private TemplateManager templateManager;

    protected AsyncRendererJobRequest castRequest(Request request) {
        AsyncRendererJobRequest indexerRequest = request instanceof AsyncRendererJobRequest ? (AsyncRendererJobRequest)request : new AsyncRendererJobRequest(request);
        return indexerRequest;
    }

    protected AsyncRendererJobStatus createNewStatus(AsyncRendererJobRequest request) {
        return new AsyncRendererJobStatus(request, this.observationManager, this.loggerManager);
    }

    public String getType() {
        return "asyncrenderer";
    }

    protected void runInternal() throws Exception {
        AsyncRenderer renderer = ((AsyncRendererJobRequest)this.getRequest()).getRenderer();
        this.asyncContext.setEnabled(!renderer.isCacheAllowed());
        ((DefaultAsyncContext)this.asyncContext).pushContextUse();
        this.templateManager.execute("xwikivars.vm");
        AsyncRendererResult result = renderer.render(true, renderer.isCacheAllowed());
        ((AsyncRendererJobStatus)this.getStatus()).setResult(result);
        DefaultAsyncContext.ContextUse contextUse = ((DefaultAsyncContext)this.asyncContext).popContextUse();
        ((AsyncRendererJobStatus)this.getStatus()).setReferences(contextUse.getReferences());
        ((AsyncRendererJobStatus)this.getStatus()).setRoles(contextUse.getRoles());
        ((AsyncRendererJobStatus)this.getStatus()).setRoleTypes(contextUse.getRoleTypes());
        ((AsyncRendererJobStatus)this.getStatus()).setUses(contextUse.getUses());
    }

    protected void jobFinished(Throwable error) {
        super.jobFinished(error);
        this.cache.put((AsyncRendererJobStatus)this.getStatus());
    }
}

