/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.async.internal.service;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.internal.context.RequestInitializer;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.container.Container;
import org.xwiki.container.Response;
import org.xwiki.container.servlet.ServletResponse;
import org.xwiki.job.event.status.JobStatus;
import org.xwiki.rendering.async.AsyncContextHandler;
import org.xwiki.rendering.async.internal.AsyncRendererExecutor;
import org.xwiki.rendering.async.internal.AsyncRendererJobStatus;
import org.xwiki.rendering.async.internal.service.AsyncRendererResourceReference;
import org.xwiki.resource.AbstractResourceReferenceHandler;
import org.xwiki.resource.ResourceReference;
import org.xwiki.resource.ResourceReferenceHandlerChain;
import org.xwiki.resource.ResourceReferenceHandlerException;
import org.xwiki.resource.ResourceType;

@Component
@Named(value="asyncrenderer")
@Singleton
public class AsyncRendererResourceReferenceHandler
extends AbstractResourceReferenceHandler<ResourceType> {
    public static final String HINT = "asyncrenderer";
    public static final ResourceType TYPE = new ResourceType("asyncrenderer");
    @Inject
    private AsyncRendererExecutor executor;
    @Inject
    private Container container;
    @Inject
    private ComponentManager componentManager;
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    private RequestInitializer requestInitializer;
    @Inject
    private Logger logger;

    public List<ResourceType> getSupportedResourceReferences() {
        return Arrays.asList(TYPE);
    }

    public void handle(ResourceReference resourceReference, ResourceReferenceHandlerChain chain) throws ResourceReferenceHandlerException {
        AsyncRendererJobStatus status;
        AsyncRendererResourceReference reference = (AsyncRendererResourceReference)resourceReference;
        String clientId = reference.getClientId();
        if (clientId == null) {
            throw new ResourceReferenceHandlerException("Client id is mandatory");
        }
        try {
            status = this.executor.getAsyncStatus(reference.getId(), clientId, reference.getTimeout(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new ResourceReferenceHandlerException("Failed to get content", (Throwable)e);
        }
        if (status == null) {
            throw new ResourceReferenceHandlerException("Cannot find any status for id [" + reference.getId() + "]");
        }
        if (status.getState() != JobStatus.State.FINISHED) {
            this.sendRUNNINGResponse(status);
        } else {
            this.sendFINISHEDResponse(reference, status);
        }
        chain.handleNext((ResourceReference)reference);
    }

    private void sendRUNNINGResponse(AsyncRendererJobStatus status) {
        Response response = this.container.getResponse();
        response.setContentType("application/json; charset=utf-8");
        if (response instanceof ServletResponse) {
            ((ServletResponse)response).getHttpServletResponse().setStatus(202);
        }
    }

    private void sendFINISHEDResponse(AsyncRendererResourceReference reference, AsyncRendererJobStatus status) throws ResourceReferenceHandlerException {
        Response response = this.container.getResponse();
        response.setContentType("text/html; charset=utf-8");
        this.addUse(reference, status, response);
        try (OutputStream stream = response.getOutputStream();){
            if (status.getError() != null) {
                IOUtils.write((String)this.toHTML(status.getError()), (OutputStream)stream, (Charset)StandardCharsets.UTF_8);
            } else if (status.getResult() != null && status.getResult().getResult() != null) {
                IOUtils.write((String)status.getResult().getResult(), (OutputStream)stream, (Charset)StandardCharsets.UTF_8);
            } else {
                IOUtils.write((String)"", (OutputStream)stream, (Charset)StandardCharsets.UTF_8);
            }
        }
        catch (Exception e) {
            throw new ResourceReferenceHandlerException("Failed to send content", (Throwable)e);
        }
    }

    private void addUse(AsyncRendererResourceReference reference, AsyncRendererJobStatus status, Response response) {
        Map uses = status.getUses();
        if (uses != null && response instanceof ServletResponse) {
            StringBuilder head = new StringBuilder();
            StringBuilder scripts = new StringBuilder();
            for (Map.Entry entry : uses.entrySet()) {
                try {
                    AsyncContextHandler handler = (AsyncContextHandler)this.componentManager.getInstance(AsyncContextHandler.class, (String)entry.getKey());
                    this.requestInitializer.restoreRequest(reference.getWiki(), (XWikiContext)this.xcontextProvider.get());
                    handler.addHTMLHead(head, (Collection)entry.getValue(), false);
                    handler.addHTMLScripts(scripts, (Collection)entry.getValue());
                }
                catch (Exception e) {
                    this.logger.error("Failed to get HTML head for handler type [{}]", entry.getKey(), (Object)e);
                }
            }
            if (head.length() > 0) {
                ((ServletResponse)response).getHttpServletResponse().addHeader("X-XWIKI-HTML-HEAD", head.toString());
            }
            if (scripts.length() > 0) {
                ((ServletResponse)response).getHttpServletResponse().addHeader("X-XWIKI-HTML-SCRIPTS", scripts.toString());
            }
        }
    }

    private String toHTML(Throwable t) {
        String content = StringEscapeUtils.escapeHtml4((String)ExceptionUtils.getStackTrace((Throwable)t));
        content = content.replace(" ", "&nbsp;");
        content = content.replace("\n", "<br/>");
        return content;
    }
}

