/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.async.internal;

import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.internal.event.EntityEvent;
import com.xpn.xwiki.internal.event.XClassPropertyAddedEvent;
import com.xpn.xwiki.internal.event.XClassPropertyDeletedEvent;
import com.xpn.xwiki.internal.event.XClassPropertyUpdatedEvent;
import com.xpn.xwiki.internal.event.XObjectAddedEvent;
import com.xpn.xwiki.internal.event.XObjectDeletedEvent;
import com.xpn.xwiki.internal.event.XObjectEvent;
import com.xpn.xwiki.internal.event.XObjectUpdatedEvent;
import com.xpn.xwiki.objects.BaseObject;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.bridge.event.DocumentCreatedEvent;
import org.xwiki.bridge.event.DocumentDeletedEvent;
import org.xwiki.bridge.event.DocumentUpdatedEvent;
import org.xwiki.bridge.event.WikiDeletedEvent;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.event.ComponentDescriptorAddedEvent;
import org.xwiki.component.event.ComponentDescriptorEvent;
import org.xwiki.component.event.ComponentDescriptorRemovedEvent;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.observation.AbstractEventListener;
import org.xwiki.observation.event.Event;
import org.xwiki.rendering.async.internal.AsyncRendererCache;
import org.xwiki.security.authorization.event.RightUpdatedEvent;

@Component
@Singleton
@Named(value="org.xwiki.rendering.async.internal.AsyncRendererCacheListener")
public class AsyncRendererCacheListener
extends AbstractEventListener {
    public static final String NAME = "org.xwiki.rendering.async.internal.AsyncRendererCacheListener";
    @Inject
    private AsyncRendererCache cache;

    public AsyncRendererCacheListener() {
        super(NAME, new Event[]{new WikiDeletedEvent(), new XClassPropertyAddedEvent(), new XClassPropertyDeletedEvent(), new XClassPropertyUpdatedEvent(), new XObjectAddedEvent(), new XObjectDeletedEvent(), new XObjectUpdatedEvent(), new DocumentCreatedEvent(), new DocumentUpdatedEvent(), new DocumentDeletedEvent(), new ComponentDescriptorAddedEvent(), new ComponentDescriptorRemovedEvent(), new RightUpdatedEvent()});
    }

    public void onEvent(Event event, Object source, Object data) {
        if (event instanceof RightUpdatedEvent) {
            this.cache.cleanCacheForRight();
        } else if (event instanceof ComponentDescriptorEvent) {
            ComponentDescriptorEvent componentEvent = (ComponentDescriptorEvent)event;
            this.cache.cleanCache(componentEvent.getRoleType(), componentEvent.getRoleHint());
        } else if (event instanceof WikiDeletedEvent) {
            WikiReference wikiReference = new WikiReference(((WikiDeletedEvent)event).getWikiId());
            this.cache.cleanCache(wikiReference.getName());
        } else {
            XWikiDocument document = (XWikiDocument)source;
            this.cache.cleanCache((EntityReference)document.getDocumentReference());
            this.cache.cleanCache((EntityReference)document.getDocumentReferenceWithLocale());
            if (event instanceof EntityEvent) {
                this.onEntityEvent((EntityEvent)event, document);
            }
        }
    }

    private void onEntityEvent(EntityEvent event, XWikiDocument document) {
        this.cache.cleanCache(event.getReference());
        if (event instanceof XObjectEvent) {
            XObjectEvent objectEvent = (XObjectEvent)event;
            BaseObject obj = objectEvent instanceof XObjectDeletedEvent ? document.getOriginalDocument().getXObject(objectEvent.getReference()) : document.getXObject(objectEvent.getReference());
            this.cache.cleanCache((EntityReference)obj.getXClassReference());
        }
    }
}

