/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.async.internal;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.cache.Cache;
import org.xwiki.cache.CacheEntry;
import org.xwiki.cache.CacheException;
import org.xwiki.cache.CacheManager;
import org.xwiki.cache.config.CacheConfiguration;
import org.xwiki.cache.config.LRUCacheConfiguration;
import org.xwiki.cache.event.CacheEntryEvent;
import org.xwiki.cache.event.CacheEntryListener;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.descriptor.ComponentRole;
import org.xwiki.component.descriptor.DefaultComponentRole;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.rendering.async.internal.AsyncRendererJobRequest;
import org.xwiki.rendering.async.internal.AsyncRendererJobStatus;
import org.xwiki.rendering.async.internal.DefaultAsyncContext;
import org.xwiki.security.authorization.AuthorizationManager;

@Component(roles={AsyncRendererCache.class})
@Singleton
public class AsyncRendererCache
implements Initializable,
CacheEntryListener<AsyncRendererJobStatus> {
    @Inject
    private AuthorizationManager authorization;
    @Inject
    private CacheManager cacheManager;
    private Cache<AsyncRendererJobStatus> asyncCache;
    private Cache<AsyncRendererJobStatus> longCache;
    private final Map<EntityReference, Set<String>> referenceMapping = new ConcurrentHashMap<EntityReference, Set<String>>();
    private final Map<Type, Set<String>> roleTypeMapping = new ConcurrentHashMap<Type, Set<String>>();
    private final Map<ComponentRole<?>, Set<String>> roleMapping = new ConcurrentHashMap();
    private final Map<DefaultAsyncContext.RightEntry, Set<String>> rightMapping = new ConcurrentHashMap<DefaultAsyncContext.RightEntry, Set<String>>();
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    public ReentrantReadWriteLock getLock() {
        return this.lock;
    }

    public static String toCacheKey(List<String> jobId) {
        StringBuilder builder = new StringBuilder();
        for (String element : jobId) {
            builder.append(element.length()).append(':').append(element);
        }
        return builder.toString();
    }

    public void initialize() throws InitializationException {
        try {
            this.longCache = this.cacheManager.createNewCache((CacheConfiguration)new LRUCacheConfiguration("rendering.asyncrenderer.long", 100, 86400));
            this.asyncCache = this.cacheManager.createNewCache((CacheConfiguration)new LRUCacheConfiguration("rendering.asyncrenderer.async", 10000, 600));
        }
        catch (CacheException e) {
            throw new InitializationException("Failed to initialize cache", (Throwable)e);
        }
        this.longCache.addCacheEntryListener((CacheEntryListener)this);
    }

    public AsyncRendererJobStatus getSync(List<String> id) {
        String cacheKey = AsyncRendererCache.toCacheKey(id);
        return (AsyncRendererJobStatus)this.longCache.get(cacheKey);
    }

    public AsyncRendererJobStatus getAsync(String clientId) {
        AsyncRendererJobStatus status = (AsyncRendererJobStatus)this.asyncCache.get(clientId);
        if (status != null) {
            this.asyncCache.remove(clientId);
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(AsyncRendererJobStatus status) {
        this.lock.writeLock().lock();
        try {
            boolean longCacheAllowed = ((AsyncRendererJobRequest)status.getRequest()).getRenderer() != null && ((AsyncRendererJobRequest)status.getRequest()).getRenderer().isCacheAllowed();
            status.dispose();
            String cacheKey = AsyncRendererCache.toCacheKey(((AsyncRendererJobRequest)status.getRequest()).getId());
            if (longCacheAllowed) {
                this.longCache.set(cacheKey, (Object)status);
            }
            for (String clientId : status.getClients()) {
                this.asyncCache.set(clientId, (Object)status);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void flush() {
        this.longCache.removeAll();
        this.asyncCache.removeAll();
    }

    public void cacheEntryAdded(CacheEntryEvent<AsyncRendererJobStatus> event) {
        CacheEntry entry = event.getEntry();
        AsyncRendererJobStatus status = (AsyncRendererJobStatus)entry.getValue();
        String key = entry.getKey();
        for (EntityReference reference : status.getReferences()) {
            this.referenceMapping.computeIfAbsent(reference, k -> ConcurrentHashMap.newKeySet()).add(key);
        }
        for (Type role : status.getRoleTypes()) {
            this.roleTypeMapping.computeIfAbsent(role, k -> ConcurrentHashMap.newKeySet()).add(key);
        }
        for (Type role : status.getRoles()) {
            this.roleMapping.computeIfAbsent((ComponentRole<?>)role, (Function<ComponentRole<?>, Set<String>>)((Function<ComponentRole, Set>)k -> ConcurrentHashMap.newKeySet())).add(key);
        }
        for (DefaultAsyncContext.RightEntry right : status.getRights()) {
            this.rightMapping.computeIfAbsent(right, k -> ConcurrentHashMap.newKeySet()).add(key);
        }
    }

    public void cacheEntryRemoved(CacheEntryEvent<AsyncRendererJobStatus> event) {
        CacheEntry entry = event.getEntry();
        AsyncRendererJobStatus status = (AsyncRendererJobStatus)entry.getValue();
        String key = entry.getKey();
        this.remove(key, status.getReferences(), this.referenceMapping);
        this.remove(key, status.getRoleTypes(), this.roleTypeMapping);
        this.remove(key, status.getRoles(), this.roleMapping);
    }

    private <T> void remove(String key, Set<T> values, Map<T, Set<String>> mapping) {
        for (T value : values) {
            Set<String> keys = mapping.get(value);
            if (keys == null) continue;
            keys.remove(key);
            if (!keys.isEmpty()) continue;
            mapping.remove(value);
        }
    }

    public void cacheEntryModified(CacheEntryEvent<AsyncRendererJobStatus> event) {
        this.cacheEntryAdded(event);
    }

    public void cleanCache(EntityReference reference) {
        if (reference != null) {
            this.clean(this.referenceMapping.remove(reference));
            this.cleanCache(reference.getParent());
        }
    }

    public void cleanCache(String wiki) {
        for (Map.Entry<EntityReference, Set<String>> entry : this.referenceMapping.entrySet()) {
            EntityReference reference = entry.getKey();
            if (!reference.getRoot().getName().equals(wiki)) continue;
            this.cleanCache(reference);
        }
    }

    public void cleanCache(Type roleType, String roleHint) {
        this.clean(this.roleTypeMapping.remove(roleType));
        this.clean(this.roleMapping.remove(new DefaultComponentRole(roleType, roleHint)));
    }

    public void cleanCacheForRight() {
        this.rightMapping.forEach(this::checkRight);
    }

    private void checkRight(DefaultAsyncContext.RightEntry right, Set<String> keys) {
        this.clean(keys);
    }

    private void clean(Set<String> keys) {
        if (keys != null) {
            for (String key : keys) {
                this.longCache.remove(key);
            }
        }
    }
}

