/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.parser.pygments;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleScriptContext;
import org.apache.commons.io.IOUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.NewLineBlock;
import org.xwiki.rendering.internal.parser.pygments.BlocksGeneratorPygmentsListener;
import org.xwiki.rendering.internal.parser.pygments.PygmentsParserConfiguration;
import org.xwiki.rendering.parser.AbstractHighlightParser;
import org.xwiki.rendering.parser.HighlightParser;
import org.xwiki.rendering.parser.ParseException;
import org.xwiki.rendering.parser.Parser;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.syntax.SyntaxType;

@Component(roles={HighlightParser.class})
@Singleton
public class PygmentsParser
extends AbstractHighlightParser
implements Initializable {
    private static final String PY_STYLE_VARNAME = "style";
    private static final String PY_LISTENER_VARNAME = "listener";
    private static final String PY_CODE_VARNAME = "code";
    private static final String PY_LANGUAGE_VARNAME = "language";
    private static final String PY_LEXER_VARNAME = "pygmentLexer";
    private static final String ENGINE_ID = "python";
    private Syntax syntax;
    @Inject
    @Named(value="plain/1.0")
    private Parser plainTextParser;
    @Inject
    private PygmentsParserConfiguration configuration;
    private ScriptEngine engine;
    private String script;

    public void initialize() throws InitializationException {
        ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
        InputStream is = this.getClass().getResourceAsStream("/pygments/code.py");
        if (is != null) {
            try {
                this.script = IOUtils.toString((InputStream)is, (String)"UTF8");
            }
            catch (Exception e) {
                throw new InitializationException("Failed to read resource /pygments/code.py resource", (Throwable)e);
            }
            finally {
                IOUtils.closeQuietly((InputStream)is);
            }
        } else {
            throw new InitializationException("Failed to find resource /pygments/code.py resource");
        }
        this.engine = scriptEngineManager.getEngineByName(ENGINE_ID);
        if (this.engine == null) {
            throw new InitializationException("Failed to find engine for Python script language");
        }
        String highlightSyntaxId = this.getSyntaxId() + "-highlight";
        this.syntax = new Syntax(new SyntaxType(highlightSyntaxId, highlightSyntaxId), "1.0");
    }

    public Syntax getSyntax() {
        return this.syntax;
    }

    @Override
    public List<Block> highlight(String syntaxId, Reader source) throws ParseException {
        List<Block> blocks;
        String code;
        try {
            code = IOUtils.toString((Reader)source);
        }
        catch (IOException e) {
            throw new ParseException("Failed to read source", (Throwable)e);
        }
        if (code.length() == 0) {
            return Collections.emptyList();
        }
        try {
            blocks = this.highlight(syntaxId, code);
        }
        catch (ScriptException e) {
            throw new ParseException("Failed to highlight code", (Throwable)e);
        }
        if (code.charAt(code.length() - 1) != '\n' && !blocks.isEmpty() && blocks.get(blocks.size() - 1) instanceof NewLineBlock) {
            blocks.remove(blocks.size() - 1);
        }
        return blocks;
    }

    private List<Block> highlight(String syntaxId, String code) throws ScriptException, ParseException {
        BlocksGeneratorPygmentsListener listener = new BlocksGeneratorPygmentsListener(this.plainTextParser);
        SimpleScriptContext scriptContext = new SimpleScriptContext();
        scriptContext.setAttribute(PY_LANGUAGE_VARNAME, syntaxId, 100);
        scriptContext.setAttribute(PY_CODE_VARNAME, code, 100);
        scriptContext.setAttribute(PY_STYLE_VARNAME, this.configuration.getStyle(), 100);
        scriptContext.setAttribute(PY_LISTENER_VARNAME, listener, 100);
        this.engine.eval(this.script, (ScriptContext)scriptContext);
        List blocks = scriptContext.getAttribute(PY_LEXER_VARNAME) != null ? listener.getBlocks() : ((Block)this.plainTextParser.parse((Reader)new StringReader(code)).getChildren().get(0)).getChildren();
        return blocks;
    }
}

